/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.blazemeter;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.blazemeter.BlazeMeterClient;
import us.abstracta.jmeter.javadsl.blazemeter.BlazeMeterTestPlanStats;
import us.abstracta.jmeter.javadsl.blazemeter.api.Project;
import us.abstracta.jmeter.javadsl.blazemeter.api.Test;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestConfig;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRun;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunConfig;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunRequestStats;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunStatus;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunSummaryStats;
import us.abstracta.jmeter.javadsl.engines.BaseRemoteEngine;

public class BlazeMeterEngine
extends BaseRemoteEngine<BlazeMeterClient, BlazeMeterTestPlanStats> {
    private static final Logger LOG = LoggerFactory.getLogger(BlazeMeterEngine.class);
    private static final Duration STATUS_POLL_PERIOD = Duration.ofSeconds(5L);
    private final String username;
    private final String password;
    private String testName = "jmeter-java-dsl";
    private Long projectId;
    private Duration testTimeout = Duration.ofHours(1L);
    private Duration availableDataTimeout = Duration.ofSeconds(30L);
    private Integer totalUsers;
    private Duration rampUp;
    private Integer iterations;
    private Duration holdFor;
    private Integer threadsPerEngine;
    private boolean useDebugRun;

    public BlazeMeterEngine(String authToken) {
        int tokenSeparatorIndex = authToken.indexOf(58);
        if (tokenSeparatorIndex < 0) {
            throw new IllegalArgumentException("BlazeMeter token does not match with expected format: <apikey>:<secretKey>");
        }
        this.username = authToken.substring(0, tokenSeparatorIndex);
        this.password = authToken.substring(tokenSeparatorIndex + 1);
    }

    public BlazeMeterEngine testName(String testName) {
        this.testName = testName;
        return this;
    }

    public BlazeMeterEngine projectId(long projectId) {
        this.projectId = projectId;
        return this;
    }

    public BlazeMeterEngine testTimeout(Duration testTimeout) {
        this.testTimeout = testTimeout;
        return this;
    }

    public BlazeMeterEngine availableDataTimeout(Duration availableDataTimeout) {
        this.availableDataTimeout = availableDataTimeout;
        return this;
    }

    public BlazeMeterEngine totalUsers(int totalUsers) {
        this.totalUsers = totalUsers;
        return this;
    }

    public BlazeMeterEngine rampUpFor(Duration rampUp) {
        this.rampUp = rampUp;
        return this;
    }

    public BlazeMeterEngine iterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    public BlazeMeterEngine holdFor(Duration holdFor) {
        this.holdFor = holdFor;
        return this;
    }

    public BlazeMeterEngine threadsPerEngine(int threadsPerEngine) {
        this.threadsPerEngine = threadsPerEngine;
        return this;
    }

    public BlazeMeterEngine useDebugRun() {
        return this.useDebugRun(true);
    }

    public BlazeMeterEngine useDebugRun(boolean enable) {
        this.useDebugRun = enable;
        return this;
    }

    protected BlazeMeterTestPlanStats run(File jmxFile, HashTree tree) throws IOException, InterruptedException, TimeoutException {
        Project project = this.findProject();
        Test test = ((BlazeMeterClient)this.apiClient).findTestByName(this.testName, project).orElse(null);
        TestConfig testConfig = this.buildTestConfig(project, jmxFile, tree);
        if (test != null) {
            ((BlazeMeterClient)this.apiClient).updateTest(test, testConfig);
            LOG.info("Updated test {}", (Object)test.getUrl());
        } else {
            test = ((BlazeMeterClient)this.apiClient).createTest(testConfig, project);
            LOG.info("Created test {}", (Object)test.getUrl());
        }
        ((BlazeMeterClient)this.apiClient).uploadTestFile(test, jmxFile);
        TestRun testRun = ((BlazeMeterClient)this.apiClient).startTest(test, this.buildTestRunConfig());
        LOG.info("Started test run {}", (Object)testRun.getUrl());
        this.awaitTestEnd(testRun);
        return this.findTestPlanStats(testRun);
    }

    protected BlazeMeterClient buildClient() {
        return new BlazeMeterClient(this.username, this.password);
    }

    private Project findProject() throws IOException {
        return this.projectId == null ? ((BlazeMeterClient)this.apiClient).findDefaultProject() : ((BlazeMeterClient)this.apiClient).findProjectById(this.projectId);
    }

    private TestConfig buildTestConfig(Project project, File jmxFile, HashTree tree) {
        TestConfig.ExecutionConfig execConfig = this.totalUsers == null && this.rampUp == null && this.iterations == null && this.holdFor == null ? TestConfig.ExecutionConfig.fromThreadGroup(this.extractFirstThreadGroup(tree)) : new TestConfig.ExecutionConfig(this.totalUsers != null ? this.totalUsers : 1, this.rampUp != null ? this.rampUp : Duration.ZERO, this.iterations != null ? this.iterations : -1, (Duration)(this.holdFor != null ? this.holdFor : (this.iterations != null ? null : Duration.ofSeconds(10L))));
        return new TestConfig().name(this.testName).projectId(project.getId()).jmxFile(jmxFile).execConfig(execConfig).threadsPerEngine(this.threadsPerEngine);
    }

    private TestRunConfig buildTestRunConfig() {
        TestRunConfig ret = new TestRunConfig();
        if (this.useDebugRun) {
            ret.debugRun();
        }
        return ret;
    }

    private void awaitTestEnd(TestRun testRun) throws InterruptedException, IOException, TimeoutException {
        TestRunStatus status = TestRunStatus.CREATED;
        Instant testStart = Instant.now();
        do {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
            TestRunStatus newStatus = ((BlazeMeterClient)this.apiClient).findTestRunStatus(testRun);
            if (status.equals(newStatus)) continue;
            LOG.debug("Test run {} status changed to: {}", (Object)testRun.getUrl(), (Object)newStatus);
            status = newStatus;
        } while (!TestRunStatus.ENDED.equals(status) && !this.hasTimedOut(testStart, this.testTimeout));
        if (!TestRunStatus.ENDED.equals(status)) {
            throw this.buildTestTimeoutException(testRun);
        }
        if (!status.isDataAvailable()) {
            this.awaitAvailableData(testRun, testStart);
        }
    }

    private boolean hasTimedOut(Instant start, Duration timeout) {
        return Duration.between(start, Instant.now()).compareTo(timeout) >= 0;
    }

    private TimeoutException buildTestTimeoutException(TestRun testRun) {
        return new TimeoutException(String.format("Test %s didn't end after %s. If the timeout is too short, you can change it with testTimeout() method.", testRun.getUrl(), this.testTimeout));
    }

    private void awaitAvailableData(TestRun testRun, Instant testStart) throws InterruptedException, IOException, TimeoutException {
        TestRunStatus status;
        Instant dataPollStart = Instant.now();
        do {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
        } while (!(status = ((BlazeMeterClient)this.apiClient).findTestRunStatus(testRun)).isDataAvailable() && !this.hasTimedOut(testStart, this.testTimeout) && !this.hasTimedOut(dataPollStart, this.availableDataTimeout));
        if (this.hasTimedOut(testStart, this.testTimeout)) {
            throw this.buildTestTimeoutException(testRun);
        }
        if (!status.isDataAvailable()) {
            throw new TimeoutException(String.format("Test %s ended, but no data is available after %s. This is usually caused by some failure in BlazeMeter. Check bzt.log and jmeter.out, and if everything looks good you might try increasing this timeout with availableDataTimeout() method.", testRun.getUrl(), this.availableDataTimeout));
        }
    }

    private BlazeMeterTestPlanStats findTestPlanStats(TestRun testRun) throws IOException {
        TestRunSummaryStats.TestRunLabeledSummary summary = ((BlazeMeterClient)this.apiClient).findTestRunSummaryStats(testRun).getSummary().get(0);
        List<TestRunRequestStats> labeledStats = ((BlazeMeterClient)this.apiClient).findTestRunRequestStats(testRun);
        return new BlazeMeterTestPlanStats(summary, labeledStats);
    }
}

