/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.testng;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import uk.org.webcompere.systemstubs.resource.Resources;
import uk.org.webcompere.systemstubs.resource.TestResource;
import uk.org.webcompere.systemstubs.testng.SystemStub;

public class SystemStubsListener
implements IInvokedMethodListener {
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        List<TestResource> stubs = SystemStubsListener.ensureAllStubsAreInstantiated(method);
        if (method.isTestMethod()) {
            try {
                for (TestResource stub : stubs) {
                    stub.setup();
                }
            }
            catch (Exception e) {
                throw new AssertionError("Could not set up stubs", e);
            }
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (method.isTestMethod()) {
            try {
                Resources.executeCleanup(SystemStubsListener.getAllStubs(method));
            }
            catch (Exception e) {
                throw new AssertionError("Could not tidy up stubs", e);
            }
        }
    }

    private static TestResource readSystemStubResource(Field field, Object testObject) {
        if (!TestResource.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("Cannot use @SystemStub with non TestResource object in field " + field.getName() + " this one's a " + field.getType().getCanonicalName());
        }
        try {
            SystemStubsListener.makeAccessible(field);
            return (TestResource)field.get(testObject);
        }
        catch (Exception e) {
            throw new AssertionError("Cannot read field " + field.getName(), e);
        }
    }

    private static List<TestResource> getAllStubs(IInvokedMethod method) {
        Object testObject = method.getTestMethod().getInstance();
        Field[] fields = testObject.getClass().getDeclaredFields();
        return Arrays.stream(fields).filter(field -> field.isAnnotationPresent(SystemStub.class)).map(field -> SystemStubsListener.readSystemStubResource(field, testObject)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    private static List<TestResource> ensureAllStubsAreInstantiated(IInvokedMethod method) {
        Object testObject = method.getTestMethod().getInstance();
        Field[] fields = testObject.getClass().getDeclaredFields();
        return Arrays.stream(fields).filter(field -> field.isAnnotationPresent(SystemStub.class)).map(field -> SystemStubsListener.instantiateIfNecessary(field, testObject)).collect(Collectors.toList());
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Generic catch block provided as lots can go wrong when using reflection")
    private static TestResource instantiateIfNecessary(Field field, Object testObject) {
        if (!TestResource.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("Cannot use @SystemStub with non TestResource object in field " + field.getName() + " this one's a " + field.getType().getCanonicalName());
        }
        try {
            SystemStubsListener.makeAccessible(field);
            Object currentObject = field.get(testObject);
            if (currentObject == null) {
                Object newInstance = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                field.set(testObject, newInstance);
                return (TestResource)newInstance;
            }
            return (TestResource)currentObject;
        }
        catch (Exception e) {
            throw new AssertionError("Cannot access field " + field.getName(), e);
        }
    }
}

