/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.dsl.nodespecific;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.condition.HasValue;
import uk.org.webcompere.modelassert.json.condition.IsEmpty;
import uk.org.webcompere.modelassert.json.condition.MatchesTextCondition;
import uk.org.webcompere.modelassert.json.condition.Not;
import uk.org.webcompere.modelassert.json.condition.PredicateWrappedCondition;
import uk.org.webcompere.modelassert.json.dsl.Satisfies;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.Sizeable;

public interface TextNodeDsl<A>
extends Satisfies<A>,
Sizeable<A> {
    default public A satisfiesTextCondition(Condition condition) {
        return this.satisfies(new PredicateWrappedCondition("Text", JsonNode::isTextual, condition));
    }

    default public A matches(Pattern regex) {
        return this.satisfiesTextCondition(new MatchesTextCondition(regex));
    }

    default public A matches(String regex) {
        return this.satisfiesTextCondition(new MatchesTextCondition(Pattern.compile(regex)));
    }

    default public A textMatches(String conditionName, Predicate<String> predicate) {
        return this.satisfiesTextCondition(new MatchesTextCondition(conditionName, predicate));
    }

    default public A isText() {
        return this.satisfies(new PredicateWrappedCondition("Text", JsonNode::isTextual));
    }

    default public A isText(String text) {
        return this.satisfiesTextCondition(new HasValue<String>(JsonNode::asText, text));
    }

    default public A isNotText() {
        return this.satisfies(Not.not(new PredicateWrappedCondition("Text", JsonNode::isTextual)));
    }

    default public A isNotText(String text) {
        return this.satisfiesTextCondition(Not.not(new HasValue<String>(JsonNode::asText, text)));
    }

    default public A isEmptyText() {
        return this.satisfiesTextCondition(new IsEmpty());
    }

    default public A isNotEmptyText() {
        return this.satisfiesTextCondition(Not.not(new IsEmpty()));
    }

    default public A textContains(String substring) {
        return this.satisfiesTextCondition(MatchesTextCondition.textContains(substring));
    }

    default public A textDoesNotContain(String substring) {
        return this.satisfiesTextCondition(Not.not(MatchesTextCondition.textContains(substring)));
    }

    default public A textStartsWith(String substring) {
        return this.satisfiesTextCondition(MatchesTextCondition.textStartsWith(substring));
    }

    default public A textDoesNotStartWith(String substring) {
        return this.satisfiesTextCondition(Not.not(MatchesTextCondition.textStartsWith(substring)));
    }
}

