/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.Result;

public class ObjectContainsKeys
implements Condition {
    private boolean strictOrder;
    private List<String> keys;

    public ObjectContainsKeys(String key, String ... keys) {
        this(false, key, keys);
    }

    public ObjectContainsKeys(boolean strictOrder, String key, String ... keys) {
        this.keys = Stream.concat(Stream.of(key), Arrays.stream(keys)).collect(Collectors.toCollection(LinkedList::new));
        this.strictOrder = strictOrder;
    }

    @Override
    public Result test(JsonNode json) {
        if (!json.isObject() || !(json instanceof ObjectNode)) {
            return new Result(this.describe(), json.getNodeType().toString(), false);
        }
        ObjectNode objectNode = (ObjectNode)json;
        LinkedList fieldNames = new LinkedList();
        objectNode.fieldNames().forEachRemaining(fieldNames::add);
        if (this.strictOrder) {
            return new Result(this.describe(), ((Object)fieldNames).toString(), this.keys.equals(fieldNames));
        }
        return new Result(this.describe(), ((Object)fieldNames).toString(), this.keys.stream().allMatch(key -> objectNode.get(key) != null));
    }

    @Override
    public String describe() {
        if (this.keys.size() == 1) {
            return "object contains " + (this.strictOrder ? " only " : "") + "key '" + this.keys.get(0) + "'";
        }
        return "object contains keys " + this.keys + (this.strictOrder ? " in exact order" : "");
    }
}

