/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.Result;

public class NumberCondition<N extends Number>
implements Condition {
    private Comparison comparison;
    private N expected;
    private Class<? extends Number> requiredType;

    public NumberCondition(N expected, Comparison comparison) {
        this.comparison = comparison;
        this.requiredType = Number.class;
        this.expected = expected;
    }

    public NumberCondition(Class<N> requiredType, N expected, Comparison comparison) {
        this.comparison = comparison;
        this.expected = expected;
        this.requiredType = requiredType;
    }

    @Override
    public Result test(JsonNode json) {
        return new Result(this.describe(), json.asText(), this.nodePasses(json));
    }

    private boolean nodePasses(JsonNode json) {
        return this.passesTypeTest(json) && this.passesNumericTest(json);
    }

    private boolean passesTypeTest(JsonNode json) {
        if (this.comparison == Comparison.NONE) {
            if (this.requiredType.equals(Integer.class)) {
                return json.isInt();
            }
            if (this.requiredType.equals(Long.class)) {
                return json.isLong();
            }
        }
        if (this.requiredType.equals(Integer.class)) {
            return json.canConvertToInt();
        }
        if (this.requiredType.equals(Long.class)) {
            return json.canConvertToLong();
        }
        if (this.requiredType.equals(Double.class)) {
            return json.isDouble();
        }
        return json.isNumber();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean passesNumericTest(JsonNode json) {
        if (this.comparison == Comparison.NONE) {
            return true;
        }
        Comparison ordering = this.getNumericComparison(json);
        if (this.comparison == ordering) return true;
        if (!Arrays.stream(this.comparison.alternatives).anyMatch(ordering::equals)) return false;
        return true;
    }

    private Comparison getNumericComparison(JsonNode json) {
        if (json.isDouble() || this.requiredType.equals(Double.class)) {
            return this.doubleComparison(json.asDouble());
        }
        if (json.isLong() || this.requiredType.equals(Long.class)) {
            return this.longComparison(json.asLong());
        }
        return this.intComparison(json.asInt());
    }

    private Comparison doubleComparison(double asDouble) {
        double expectedDouble = ((Number)this.expected).doubleValue();
        if (asDouble == expectedDouble) {
            return Comparison.EQUAL_TO;
        }
        if (asDouble > expectedDouble) {
            return Comparison.GREATER_THAN;
        }
        return Comparison.LESS_THAN;
    }

    private Comparison longComparison(long asLong) {
        long expectedLong = ((Number)this.expected).longValue();
        if (asLong == expectedLong) {
            return Comparison.EQUAL_TO;
        }
        if (asLong > expectedLong) {
            return Comparison.GREATER_THAN;
        }
        return Comparison.LESS_THAN;
    }

    private Comparison intComparison(long asInt) {
        int expectedInt = ((Number)this.expected).intValue();
        if (asInt == (long)expectedInt) {
            return Comparison.EQUAL_TO;
        }
        if (asInt > (long)expectedInt) {
            return Comparison.GREATER_THAN;
        }
        return Comparison.LESS_THAN;
    }

    @Override
    public String describe() {
        return "is " + this.requiredType.getTypeName() + " " + this.comparison.name + " " + this.expected;
    }

    public static enum Comparison {
        NONE("correct type", new Comparison[0]),
        EQUAL_TO("equal to", new Comparison[0]),
        GREATER_THAN("greater than", new Comparison[0]),
        GREATER_THAN_OR_EQUAL("greater than or equal to", new Comparison[]{GREATER_THAN, EQUAL_TO}),
        LESS_THAN("less than", new Comparison[0]),
        LESS_THAN_OR_EQUAL("less than or equal to", new Comparison[]{LESS_THAN, EQUAL_TO});

        private String name;
        private Comparison[] alternatives;

        private Comparison(String name, Comparison[] alternatives) {
            this.name = name;
            this.alternatives = alternatives;
        }
    }
}

