/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition.tree;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.org.webcompere.modelassert.json.PathWildCard;
import uk.org.webcompere.modelassert.json.condition.tree.Location;
import uk.org.webcompere.modelassert.json.condition.tree.PathMatcher;

public class PathMatch {
    private static final String JSON_POINTER_DELIMITER = "/";
    private List<PathMatcher> matchers;

    public PathMatch(Object pathStart, Object ... pathRemainder) {
        this.matchers = Stream.concat(Stream.of(pathStart), Arrays.stream(pathRemainder)).map(PathMatcher::of).collect(Collectors.toList());
    }

    private PathMatch(String[] fixedPath) {
        this.matchers = Arrays.stream(fixedPath).map(PathMatcher::of).collect(Collectors.toList());
    }

    public static PathMatch all() {
        return new PathMatch((Object)PathWildCard.ANY_SUBTREE, new Object[0]);
    }

    public static PathMatch ofJsonPointer(String jsonPointer) {
        if (!jsonPointer.startsWith(JSON_POINTER_DELIMITER)) {
            throw new IllegalArgumentException("Invalid JSON Pointer, must start with /");
        }
        String[] parts = jsonPointer.split(JSON_POINTER_DELIMITER);
        if (Arrays.stream(parts).skip(1L).anyMatch(part -> !part.trim().equals(part) || part.isEmpty())) {
            throw new IllegalArgumentException("Invalid spacing or blanks in " + jsonPointer);
        }
        return new PathMatch((String[])Arrays.stream(parts).skip(1L).toArray(String[]::new));
    }

    public boolean matches(Location location) {
        if (this.matchers.isEmpty()) {
            return location.isEmpty();
        }
        return this.matchers.get(0).matches(location, this.matchers.subList(1, this.matchers.size()));
    }

    public String toString() {
        return this.matchers.toString();
    }
}

