/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.jcip.annotations.ThreadSafe;
import org.w3c.dom.Document;
import uk.org.retep.util.nio.ByteBufferInputStream;
import uk.org.retep.util.nio.DelegatingSocketProcessor;
import uk.org.retep.util.nio.SocketProcessorHandler;
import uk.org.retep.util.xml.XMLStreamParser;

@ThreadSafe
public abstract class StAXSocketProcessorHandler<P extends DelegatingSocketProcessor>
extends SocketProcessorHandler<P>
implements XMLStreamParser.Listener<XMLStreamParser> {
    private XMLStreamParser parser = new XMLStreamParser(this.createDocument());
    private ByteBufferInputStream inputStream;
    private XMLStreamReader xmlStreamReader;

    public StAXSocketProcessorHandler(P processor, SocketChannel channel) throws ParserConfigurationException, XMLStreamException {
        super(processor, channel);
        this.parser.addListener(this);
    }

    protected abstract Document createDocument() throws ParserConfigurationException;

    protected abstract XMLStreamReader createXMLStreamReader(InputStream var1) throws XMLStreamException;

    protected final XMLStreamReader getXMLStreamReader(ByteBuffer buffer) throws XMLStreamException {
        if (this.inputStream == null) {
            this.inputStream = new ByteBufferInputStream(buffer);
        }
        if (this.xmlStreamReader == null) {
            this.xmlStreamReader = this.createXMLStreamReader(this.inputStream);
        }
        return this.xmlStreamReader;
    }

    @Override
    public void read(SocketChannel channel, ByteBuffer buffer) throws IOException {
        try {
            this.getLog().info("A %d %d", buffer.position(), buffer.limit());
            this.getXMLStreamReader(buffer);
            this.getLog().info("B %d %d", buffer.position(), buffer.limit());
            while (true) {
                if (this.xmlStreamReader.hasNext()) {
                    this.getLog().info("C %d %d", buffer.position(), buffer.limit());
                    this.parser.processEvents(this.xmlStreamReader);
                    continue;
                }
                this.getLog().info("D %d %d", buffer.position(), buffer.limit());
                if (this.inputStream.available() <= 0) break;
            }
            this.getLog().info("E %d %d", buffer.position(), buffer.limit());
        }
        catch (XMLStreamException ex) {
            this.parser.notifyStreamError(ex);
            throw new IOException(ex);
        }
    }

    @Override
    public void closing(SocketChannel channel) {
        if (this.parser != null) {
            this.parser.notifyStreamClosed();
            this.parser.removeListener(this);
            this.parser = null;
        }
        if (this.xmlStreamReader != null) {
            try {
                this.xmlStreamReader.close();
            }
            catch (XMLStreamException ex) {
                this.getLog().info((Object)"Exception closing XMLStreamParser", ex);
            }
            this.xmlStreamReader = null;
        }
        super.closing(channel);
    }

    @Override
    public void STaXThreadClosed(XMLStreamParser t) {
    }

    @Override
    public void STaXThreadError(XMLStreamParser t, Exception e) {
    }
}

