/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.messaging.router;

import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.messaging.Component;
import uk.org.retep.util.messaging.DefaultableRouter;
import uk.org.retep.util.messaging.Message;
import uk.org.retep.util.messaging.MessageException;
import uk.org.retep.util.messaging.router.AbstractRouter;

@ThreadSafe
public abstract class AbstractDefaultRouter<K, R>
extends AbstractRouter<K, R>
implements DefaultableRouter<K, R> {
    private Component<K, Message<K>> defaultRoute;

    public AbstractDefaultRouter() {
    }

    public AbstractDefaultRouter(K key) {
        super(key);
    }

    @Override
    public void startComponent() throws MessageException {
        super.startComponent();
        Component<K, Message<K>> component = this.getDefaultRoute();
        if (component != null) {
            try {
                component.startComponent();
            }
            catch (MessageException me) {
                super.stopComponent();
                throw me;
            }
            catch (RuntimeException re) {
                super.stopComponent();
                throw re;
            }
        }
    }

    @Override
    public void stopComponent() {
        Component<K, Message<K>> component = this.getDefaultRoute();
        if (component != null) {
            try {
                component.stopComponent();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.stopComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public final Component<K, Message<K>> getDefaultRoute() {
        this.readLock().lock();
        try {
            Component<K, Message<K>> component = this.defaultRoute;
            return component;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public final Component<K, Message<K>> setDefaultRoute(Component<K, Message<K>> defaultRoute) throws MessageException {
        this.writeLock().lock();
        try {
            Component<K, Message<K>> oldRoute = this.defaultRoute;
            if (oldRoute != null && this.isComponentStarted()) {
                oldRoute.stopComponent();
            }
            this.defaultRoute = defaultRoute;
            if (defaultRoute != null && this.isComponentStarted()) {
                defaultRoute.startComponent();
            }
            Component<K, Message<K>> component = oldRoute;
            return component;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    protected void unknownRoute(Message<K> message) throws MessageException {
        Component<K, Message<K>> component = this.getDefaultRoute();
        if (component == null) {
            super.unknownRoute(message);
        } else {
            this.getLog().debug("Routing to %s", component);
            component.consume(message);
        }
    }
}

