/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import uk.org.retep.util.io.PatternFileFilter;

public abstract class PackageFileFilter
extends PatternFileFilter {
    private static final String DOT_REGEX2 = DOT_REGEX + "[[^\\.]+" + DOT_REGEX + "]*?";
    private static final String START = "^";
    private static final String WILDCARD = ".*";
    private static final String FILE = "[^" + DOT_REGEX + "]+$";

    private PackageFileFilter(File baseDirectory) {
        super(baseDirectory);
    }

    private PackageFileFilter(File baseDirectory, Pattern ... patterns) {
        super(baseDirectory, patterns);
    }

    private PackageFileFilter(File baseDirectory, String ... globs) {
        super(baseDirectory, globs);
    }

    private PackageFileFilter(File baseDirectory, Collection<?> patterns) {
        super(baseDirectory, patterns);
    }

    @Override
    public final void add(String glob) {
        if (glob.startsWith("*.")) {
            this.add(Pattern.compile("^.*" + PackageFileFilter.convertPackage(glob.substring(2)) + FILE));
        } else if (glob.endsWith(WILDCARD)) {
            this.add(Pattern.compile(START + PackageFileFilter.convertPackage(glob.substring(0, glob.length() - 2)) + DOT_REGEX2 + FILE));
        } else {
            this.add(Pattern.compile(START + PackageFileFilter.convertPackage(glob) + DOT_REGEX + FILE));
        }
    }

    public static final class Exclude
    extends PackageFileFilter {
        public Exclude(File baseDirectory, Pattern ... patterns) {
            super(baseDirectory, patterns);
        }

        public Exclude(File baseDirectory, String ... globs) {
            super(baseDirectory, globs);
        }

        public Exclude(File baseDirectory, Collection<?> patterns) {
            super(baseDirectory, patterns);
        }

        @Override
        public final boolean accept(File file) {
            return this.inScope(file) && !this.matches(file);
        }
    }

    public static final class Include
    extends PackageFileFilter {
        public Include(File baseDirectory, Pattern ... patterns) {
            super(baseDirectory, patterns);
        }

        public Include(File baseDirectory, String ... globs) {
            super(baseDirectory, globs);
        }

        public Include(File baseDirectory, Collection<?> patterns) {
            super(baseDirectory, patterns);
        }

        @Override
        public final boolean accept(File file) {
            return this.inScope(file) && this.matches(file);
        }
    }
}

