/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import uk.org.retep.swing.model.AbstractModel;
import uk.org.retep.util.string.StringUtils;

public class ColorModel
extends AbstractModel<Wrapper> {
    private Wrapper[] colors;

    public ColorModel(Color defaultColor) {
        super(new Wrapper("default", defaultColor));
        TreeMap<String, Color> map = new TreeMap<String, Color>();
        try {
            for (Field f : Color.class.getFields()) {
                if (!Color.class.equals(f.getType())) continue;
                map.put(f.getName().toLowerCase(), (Color)f.get(null));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(this.getDefaultValue());
        for (Map.Entry e : map.entrySet()) {
            l.add(new Wrapper(StringUtils.capitalise((String)e.getKey()), (Color)e.getValue()));
        }
        this.colors = l.toArray(new Wrapper[l.size()]);
    }

    @Override
    public ListCellRenderer getRenderer() {
        return new ColorRenderer();
    }

    public static Color getColor(Object o) {
        return ((Wrapper)o).getColor();
    }

    @Override
    public int getSize() {
        return this.colors.length;
    }

    @Override
    public Object getElementAt(int index) {
        return this.colors[index];
    }

    public Object select(String name) {
        Wrapper selected = null;
        if (name != null) {
            for (Wrapper w : this.colors) {
                if (!name.equals(w.toString())) continue;
                selected = w;
                break;
            }
        }
        return selected;
    }

    private class ColorRenderer
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = -8010685072866470964L;
        private Map<Wrapper, ImageIcon> cache = new HashMap<Wrapper, ImageIcon>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ColorRenderer() {
            this.setOpaque(false);
            for (Wrapper end : ColorModel.this.colors) {
                BufferedImage img = new BufferedImage(20, 20, 5);
                Graphics2D g = img.createGraphics();
                try {
                    g.setColor(Color.white);
                    g.fillRect(0, 0, 20, 20);
                    g.setBackground(Color.white);
                    g.setColor(end.getColor());
                    g.fillRect(5, 5, 10, 10);
                    g.setColor(Color.black);
                    g.drawRect(5, 5, 10, 10);
                }
                finally {
                    g.dispose();
                }
                this.cache.put(end, new ImageIcon(img));
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.setText("");
                this.setIcon(null);
            } else {
                Wrapper end = (Wrapper)value;
                this.setText(end.toString());
                this.setIcon(this.cache.get(end));
            }
            return this;
        }
    }

    protected static class Wrapper {
        private String name;
        private Color color;

        Wrapper(String name, Color color) {
            this.name = name;
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public String toString() {
            return this.name;
        }
    }
}

