/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.concurrent.ConcurrencySupport;
import uk.org.retep.util.nio.DelegatingSocketProcessor;

@ThreadSafe
public abstract class SocketProcessorHandler<P extends DelegatingSocketProcessor>
extends ConcurrencySupport {
    protected P processor;

    public SocketProcessorHandler(P processor, SocketChannel channel) {
        this.processor = processor;
    }

    protected final P getProcessor() {
        return this.processor;
    }

    public void closing(SocketChannel channel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(SocketChannel channel) {
        if (this.processor != null) {
            try {
                ((DelegatingSocketProcessor)this.processor).close(this, channel);
            }
            finally {
                this.processor = null;
            }
        }
    }

    public void accept(SelectionKey key) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(SelectionKey key) throws IOException {
        boolean channelValid;
        ByteBuffer buffer = (ByteBuffer)ByteBuffer.class.cast(key.attachment());
        SocketChannel channel = (SocketChannel)SocketChannel.class.cast(key.channel());
        boolean bl = channelValid = channel.isConnected() && channel.isOpen();
        if (channelValid) {
            boolean bl2 = channelValid = channel.read(buffer) >= 0;
        }
        if (channelValid) {
            buffer.flip();
            try {
                this.read(channel, buffer);
            }
            finally {
                buffer.compact();
            }
        }
        this.getLog().error("Closing channel %s", channel);
        try {
            this.close(channel);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public abstract void read(SocketChannel var1, ByteBuffer var2) throws IOException;
}

