/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.annotation.validator;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import uk.org.retep.util.javac.JavacUtils;
import uk.org.retep.util.string.StringUtils;

public abstract class AbstractCodeAnalyser {
    private final ResourceBundle bundle;
    protected final JavacUtils javacUtils;
    protected final Elements elements;
    protected final Types types;
    private final Map<String, Boolean> options;
    private Set<Message> messages = new LinkedHashSet<Message>();
    private MetaData metadata;

    public AbstractCodeAnalyser(JavacUtils javacUtils) {
        this(javacUtils, "uk/org/retep/util/annotation/validator/messages");
    }

    public AbstractCodeAnalyser(JavacUtils javacUtils, String bundleName) {
        this.javacUtils = javacUtils;
        this.bundle = ResourceBundle.getBundle(bundleName);
        this.elements = javacUtils.processingEnv.getElementUtils();
        this.types = javacUtils.processingEnv.getTypeUtils();
        this.options = new HashMap<String, Boolean>();
        Map<String, String> annotOpts = javacUtils.processingEnv.getOptions();
        for (Map.Entry<String, String> e : annotOpts.entrySet()) {
            this.options.put(e.getKey(), Boolean.valueOf(e.getValue()));
        }
        String mavenHack = annotOpts.get("mavenOpts");
        if (StringUtils.isStringNotEmpty(mavenHack)) {
            for (String k : mavenHack.split(",")) {
                if (k.startsWith("!") || k.startsWith("^")) {
                    if (k.length() <= 1) continue;
                    this.options.put(k.substring(1), false);
                    continue;
                }
                this.options.put(k, true);
            }
        }
    }

    protected final boolean getOption(String option) {
        return this.getOption(option, false);
    }

    protected final boolean getOption(String option, boolean defaultValue) {
        Boolean value = this.options.get(option);
        return value == null ? defaultValue : value;
    }

    public final void scan(Element element) {
        Set<Element> set = Collections.singleton(element);
        if (element instanceof TypeElement) {
            this.scanType((TypeElement)element);
        }
        for (TypeElement type : ElementFilter.typesIn(element.getEnclosedElements())) {
            this.scanType(type);
        }
    }

    protected abstract MetaData createMetadata();

    protected boolean filter(TypeElement element) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scanType(TypeElement element) {
        if (!this.filter(element)) {
            return;
        }
        this.push(this.createMetadata());
        try {
            this.scanTypeStart(element);
            this.scanFields(element);
            this.scanConstructors(element);
            this.scanMethods(element);
            this.scanOther(element);
            this.scanTypeEnd(element);
        }
        finally {
            this.pop();
        }
    }

    protected void scanTypeStart(TypeElement element) {
    }

    protected void scanTypeEnd(TypeElement element) {
    }

    protected void scanConstructors(TypeElement element) {
        for (ExecutableElement method : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            this.scanConstructor(method);
        }
    }

    protected void scanConstructor(ExecutableElement constructor) {
    }

    protected void scanMethods(TypeElement element) {
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            this.scanMethod(method);
        }
    }

    protected void scanMethod(ExecutableElement method) {
    }

    protected void scanFields(TypeElement element) {
        for (VariableElement var : ElementFilter.fieldsIn(element.getEnclosedElements())) {
            this.scanField(var);
        }
    }

    protected void scanField(VariableElement var) {
    }

    protected void scanOther(TypeElement element) {
    }

    public final void report() {
        if (this.metadata != null) {
            for (Message message : this.messages) {
                message.report();
            }
            this.messages.clear();
        }
    }

    protected final void push(MetaData metadata) {
        if (this.metadata != null) {
            metadata.setParent(this.metadata);
        }
        this.metadata = metadata;
    }

    protected final void pop() {
        if (this.metadata != null) {
            this.report();
            this.metadata = this.metadata.getParent();
        } else {
            this.metadata = null;
        }
    }

    protected final <T extends MetaData> T getMetaData() {
        return (T)this.metadata;
    }

    protected final void warn(Element element, String message, Object ... args) {
        this.warn(element, null, message, args);
    }

    protected final void mandatoryWarning(Element element, String message, Object ... args) {
        this.mandatoryWarning(element, null, message, args);
    }

    protected final void error(Element element, String message, Object ... args) {
        this.error(element, null, message, args);
    }

    protected final void note(Element element, String message, Object ... args) {
        this.note(element, null, message, args);
    }

    protected final void other(Element element, String message, Object ... args) {
        this.other(element, null, message, args);
    }

    protected final void warn(Element element, Class<?> clazz, String message, Object ... args) {
        this.printMessage(element, Diagnostic.Kind.WARNING, clazz, null, null, message, args);
    }

    protected final void mandatoryWarning(Element element, Class<?> clazz, String message, Object ... args) {
        this.printMessage(element, Diagnostic.Kind.MANDATORY_WARNING, clazz, null, null, message, args);
    }

    protected final void error(Element element, Class<?> clazz, String message, Object ... args) {
        this.printMessage(element, Diagnostic.Kind.ERROR, clazz, null, null, message, args);
    }

    protected final void note(Element element, Class<?> clazz, String message, Object ... args) {
        this.printMessage(element, Diagnostic.Kind.NOTE, clazz, null, null, message, args);
    }

    protected final void other(Element element, Class<?> clazz, String message, Object ... args) {
        this.printMessage(element, Diagnostic.Kind.OTHER, clazz, null, null, message, args);
    }

    protected final void printMessage(Element element, Diagnostic.Kind kind, Class<?> clazz, AnnotationMirror annotationMirror, AnnotationValue annotationValue, String message, Object ... args) {
        this.messages.add(new Message(element, kind, annotationMirror, annotationValue, clazz, message, args));
    }

    private class Message {
        private final Element element;
        private final Diagnostic.Kind kind;
        private final AnnotationMirror annotationMirror;
        private final AnnotationValue annotationValue;
        private final String message;

        public Message(Element element, Diagnostic.Kind kind, AnnotationMirror annotationMirror, AnnotationValue annotationValue, Class<?> clazz, String message, Object ... args) {
            this.element = element;
            this.kind = kind;
            this.annotationMirror = annotationMirror;
            this.annotationValue = annotationValue;
            String msg = AbstractCodeAnalyser.this.bundle.getString(message);
            this.message = clazz == null ? StringUtils.format(msg, args) : StringUtils.format(clazz.getSimpleName() + ": " + msg, args);
        }

        public int hashCode() {
            return (this.element == null ? 1 : ((Object)this.element).hashCode()) ^ this.message.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Message) {
                Message b = (Message)Message.class.cast(obj);
                if (this.message.equals(b.message)) {
                    if (this.element == null) {
                        return b.element == null;
                    }
                    return ((Object)this.element).equals(b.element);
                }
            }
            return false;
        }

        public void report() {
            if (this.element == null) {
                AbstractCodeAnalyser.this.javacUtils.messager.printMessage(this.kind, this.message);
            } else if (this.annotationMirror == null) {
                AbstractCodeAnalyser.this.javacUtils.messager.printMessage(this.kind, this.message, this.element);
            } else if (this.annotationValue == null) {
                AbstractCodeAnalyser.this.javacUtils.messager.printMessage(this.kind, this.message, this.element);
            } else if (this.annotationValue == null) {
                AbstractCodeAnalyser.this.javacUtils.messager.printMessage(this.kind, this.message, this.element, this.annotationMirror);
            } else {
                AbstractCodeAnalyser.this.javacUtils.messager.printMessage(this.kind, this.message, this.element, this.annotationMirror, this.annotationValue);
            }
        }
    }

    public static class MetaData {
        private MetaData parent;

        void setParent(MetaData parent) {
            this.parent = parent;
        }

        MetaData getParent() {
            return this.parent;
        }
    }
}

