/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.reference;

import java.util.Collection;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.cluster.ClusteredTime;
import uk.org.retep.util.reference.DelayedWeakLinkedList;
import uk.org.retep.util.reference.ReferenceFactory;
import uk.org.retep.util.thread.DelayedRunnable;

@ThreadSafe
public class ExpiringDelayedWeakLinkedList<E>
extends DelayedWeakLinkedList<E> {
    private final long expiry;

    public ExpiringDelayedWeakLinkedList(long expiry) {
        this(expiry, 15000L);
    }

    public ExpiringDelayedWeakLinkedList(long expiry, long delay) {
        super(delay);
        this.expiry = expiry;
    }

    public ExpiringDelayedWeakLinkedList(long expiry, Collection<? extends E> c) {
        this(expiry);
        this.addAll(c);
    }

    public ExpiringDelayedWeakLinkedList(long expiry, long delay, Collection<? extends E> c) {
        this(expiry, delay);
        this.addAll(c);
    }

    public long getExpiry() {
        return this.expiry;
    }

    @Override
    protected DelayedWeakLinkedList.Entry createEntry(E element, DelayedWeakLinkedList.Entry next, DelayedWeakLinkedList.Entry previous) {
        return new ExpiringEntry(element, next, previous);
    }

    protected class ExpiringEntry
    extends DelayedWeakLinkedList.Entry
    implements DelayedRunnable {
        private final long triggerTime;

        public ExpiringEntry(E element, DelayedWeakLinkedList.Entry next, DelayedWeakLinkedList.Entry previous) {
            super(element, next, previous);
            this.triggerTime = ClusteredTime.currentClusterTimeMillis() + ExpiringDelayedWeakLinkedList.this.getExpiry();
            ReferenceFactory.getDelayThreadPoolExecutor().execute(this);
        }

        @Override
        public final long getDelay(TimeUnit unit) {
            return unit.convert(this.triggerTime - ClusteredTime.currentClusterTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public final int compareTo(Delayed d) {
            return (int)(this.getDelay(TimeUnit.MILLISECONDS) - d.getDelay(TimeUnit.MILLISECONDS));
        }

        @Override
        protected <T extends DelayedWeakLinkedList<E>> void recordRemoval(T collection) {
            ReferenceFactory.getDelayThreadPoolExecutor().remove(this);
            super.recordRemoval(collection);
        }

        @Override
        public void run() {
            ExpiringDelayedWeakLinkedList.this.removeEntry(this);
        }
    }
}

