/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.jmx;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import uk.org.retep.util.collections.stats.StatisticCollection;
import uk.org.retep.util.thread.DelayedRunnableAdaptor;
import uk.org.retep.util.thread.ExecutorFactory;

public class MemoryMonitor {
    private static final int DEFAULT_MAX_ENTRIES = 500;
    private static final long DEFAULT_DELAY = 10000L;
    private final long delay;
    private final StatisticCollection<MemoryUsage> heap;
    private final StatisticCollection<MemoryUsage> nonHeap;
    private final Map<String, StatisticCollection<MemoryUsage>> memoryPool;
    private final Map<String, Timer<MemoryPoolMXBean>> memoryPoolTimers;
    private final Timer<MemoryMXBean> memoryTimer;

    public MemoryMonitor() {
        this(500);
    }

    public MemoryMonitor(int maxEntries) {
        this(maxEntries, Long.MAX_VALUE);
    }

    public MemoryMonitor(int maxEntries, long maxAge) {
        this(maxEntries, maxAge, 10000L);
    }

    public MemoryMonitor(int maxEntries, long maxAge, long delay) {
        this.delay = delay;
        this.heap = new StatisticCollection(maxEntries, maxAge);
        this.nonHeap = new StatisticCollection(maxEntries, maxAge);
        this.memoryTimer = new Timer<MemoryMXBean>(ManagementFactory.getMemoryMXBean()){

            @Override
            protected void capture() {
                MemoryMonitor.this.heap.addValue(((MemoryMXBean)this.memory).getHeapMemoryUsage());
                MemoryMonitor.this.nonHeap.addValue(((MemoryMXBean)this.memory).getNonHeapMemoryUsage());
            }
        };
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        this.memoryPool = new HashMap<String, StatisticCollection<MemoryUsage>>();
        this.memoryPoolTimers = new HashMap<String, Timer<MemoryPoolMXBean>>();
        for (MemoryPoolMXBean pool : pools) {
            String name = pool.getName();
            final StatisticCollection col = new StatisticCollection(maxEntries, maxAge);
            this.memoryPool.put(name, col);
            this.memoryPoolTimers.put(name, new Timer<MemoryPoolMXBean>(pool){

                @Override
                protected void capture() {
                    col.addValue(((MemoryPoolMXBean)this.memory).getUsage());
                }
            });
        }
    }

    public Collection<String> getPoolNames() {
        return Collections.unmodifiableCollection(this.memoryPoolTimers.keySet());
    }

    public StatisticCollection<MemoryUsage> getHeap() {
        return this.heap;
    }

    public StatisticCollection<MemoryUsage> getNonHeap() {
        return this.nonHeap;
    }

    public StatisticCollection<MemoryUsage> getMemoryPool(String name) {
        return this.memoryPool.get(name);
    }

    @PostConstruct
    public void start() {
        this.memoryTimer.run();
        for (Timer<MemoryPoolMXBean> t : this.memoryPoolTimers.values()) {
            t.run();
        }
    }

    @PreDestroy
    public void stop() {
        ExecutorFactory.unschedule(this.memoryTimer);
        for (Timer<MemoryPoolMXBean> t : this.memoryPoolTimers.values()) {
            ExecutorFactory.unschedule(t);
        }
    }

    private abstract class Timer<T>
    extends DelayedRunnableAdaptor {
        protected final T memory;

        public Timer(T memory) {
            this.memory = memory;
        }

        public void schedule() {
            this.setDelay(MemoryMonitor.this.delay);
            ExecutorFactory.schedule(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                this.capture();
            }
            finally {
                this.schedule();
            }
        }

        protected abstract void capture();
    }
}

