/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.http.AbstractHttpHandler;
import uk.org.retep.util.http.RequestUtils;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.mime.ContentType;
import uk.org.retep.util.mime.ContentTypeFactory;
import uk.org.retep.util.string.StringUtils;

@ThreadSafe
public class StaticFileHandler
extends AbstractHttpHandler {
    private final File rootDirectory;

    public StaticFileHandler(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        this.getLog().info("Created StaticHandler for %s", rootDirectory.getAbsolutePath());
    }

    @Override
    public void processGet(HttpExchange exchange) throws IOException {
        String fullPath = exchange.getRequestURI().getPath();
        String path = fullPath.substring(exchange.getHttpContext().getPath().length());
        File file = new File(this.rootDirectory, path);
        if (file.isDirectory()) {
            file = new File(file, "index.html");
        }
        if (!file.exists()) {
            RequestUtils.sendResponse(exchange, 500, " does not exist", path);
        } else if (file.isDirectory()) {
            RequestUtils.sendResponse(exchange, 500, "%s is forbidden", path);
        } else if (!file.getCanonicalPath().startsWith(this.rootDirectory.getCanonicalPath())) {
            RequestUtils.sendResponse(exchange, 500, "%s is forbidden as it contains insecure relative paths", path);
        } else {
            this.sendFile(exchange, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(HttpExchange exchange, File file) throws IOException {
        ContentType contentType = null;
        try {
            contentType = ContentTypeFactory.getContentTypeBySuffix(StringUtils.getFileSuffix(file.getName()));
        }
        catch (IllegalArgumentException iae) {
            contentType = ContentType.TEXT_PLAIN;
        }
        RequestUtils.setContentType(exchange, contentType);
        exchange.sendResponseHeaders(200, file.length());
        OutputStream os = exchange.getResponseBody();
        try {
            FileUtils.copyFile(file, os);
        }
        finally {
            os.close();
        }
    }
}

