/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Executor;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.Contract;
import uk.org.retep.util.collections.EnumerationIterator;
import uk.org.retep.util.collections.list.ConcurrentList;
import uk.org.retep.util.collections.queue.ConcurrentDeque;
import uk.org.retep.util.collections.queue.ConcurrentObjectPool;
import uk.org.retep.util.collections.queue.ConcurrentQueue;
import uk.org.retep.util.collections.queue.ObjectPool;
import uk.org.retep.util.collections.set.ConcurrentSet;
import uk.org.retep.util.collections.set.ConcurrentSetWrapper;

@ThreadSafe
public final class CollectionUtils {
    private static final Collection<?> EMPTY_COLLECTION = new EmptyCollection();
    private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private static final Enumeration<Object> EMPTY_ENUMERATION = new Enumeration<Object>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    public static Comparator<?> LT = new NegativeComparator();
    public static Comparator<?> GT = new PositiveComparator();

    private CollectionUtils() {
    }

    public static <E> Collection<E> emptyCollection() {
        return Collections.emptyList();
    }

    public static <E> List<E> concurrentList(List<E> list) {
        return new ConcurrentList<E>(list);
    }

    public static <E> Queue<E> concurrentQueue(Queue<E> queue) {
        return new ConcurrentQueue<E>(queue);
    }

    public static <E> Deque<E> concurrentDeque(Deque<E> deque) {
        return new ConcurrentDeque<E>(deque);
    }

    public static <E> ConcurrentSet<E> concurrentSet(Collection<E> set) {
        return CollectionUtils.concurrentSet(new HashSet<E>(set));
    }

    public static <E> ConcurrentSet<E> concurrentSet(Set<E> set) {
        return new ConcurrentSetWrapper<E>(set);
    }

    public static <E extends ObjectPool.Entry> ObjectPool<E> createObjectPool(Class<E> entryClass) {
        return new ConcurrentObjectPool<E>(entryClass);
    }

    public static <E extends ObjectPool.Entry> ObjectPool<E> createObjectPool(Class<E> entryClass, int capacity) {
        return new ConcurrentObjectPool<E>(entryClass, capacity);
    }

    public static <E extends ObjectPool.Entry> ObjectPool<E> createObjectPool(Class<E> entryClass, int initialCapacity, int capacity) {
        return new ConcurrentObjectPool<E>(entryClass, initialCapacity, capacity);
    }

    public static <E extends ObjectPool.Entry> ObjectPool<E> createObjectPool(ObjectPool.Factory<E> factory) {
        return new ConcurrentObjectPool<E>(factory);
    }

    public static <E extends ObjectPool.Entry> ObjectPool<E> createObjectPool(ObjectPool.Factory<E> factory, int capacity) {
        return new ConcurrentObjectPool<E>(factory, capacity);
    }

    public static <E extends ObjectPool.Entry> ObjectPool<E> createObjectPool(ObjectPool.Factory<E> factory, int initialCapacity, int capacity) {
        return new ConcurrentObjectPool<E>(factory, initialCapacity, capacity);
    }

    public static <E extends ObjectPool.Entry> ObjectPool<E> createObjectPool(ObjectPool.Factory<E> factory, int initialCapacity, int capacity, boolean background) {
        return new ConcurrentObjectPool<E>(factory, initialCapacity, capacity, background);
    }

    public static <E extends ObjectPool.Entry> ObjectPool<E> createObjectPool(ObjectPool.Factory<E> factory, int initialCapacity, int capacity, boolean background, Executor threadPoolExecutor) {
        return new ConcurrentObjectPool<E>(factory, initialCapacity, capacity, background, threadPoolExecutor);
    }

    public static <E> Iterator<E> singletonIterator(final E e) {
        return new Iterator<E>(){
            private boolean next = true;
            private boolean elem = true;

            @Override
            public boolean hasNext() {
                boolean ret = this.next;
                this.next = false;
                return ret;
            }

            @Override
            public E next() {
                if (!this.next && this.elem) {
                    this.elem = false;
                    return e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> Enumeration<E> singletonEnumeration(final E e) {
        return new Enumeration<E>(){
            private boolean next = true;
            private boolean elem = true;

            @Override
            public boolean hasMoreElements() {
                boolean ret = this.next;
                this.next = false;
                return ret;
            }

            @Override
            public E nextElement() {
                if (!this.next && this.elem) {
                    this.elem = false;
                    return e;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <E> Iterator<E> emptyIterator() {
        return CollectionUtils.castIterator(EMPTY_ITERATOR);
    }

    public static <E> Enumeration<E> emptyEnumeration() {
        return CollectionUtils.castEnumeration(EMPTY_ENUMERATION);
    }

    public static <E> Iterable<E> iterate(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    public static <E> Iterator<E> iterator(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    public static <E> Iterable<E> iterable(final Iterator<E> it) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return it;
            }
        };
    }

    public static <E> E getFirstElement(Collection<E> collection) {
        if (collection == null) {
            throw new NullPointerException("Collection is null");
        }
        if (collection.isEmpty()) {
            return null;
        }
        if (collection instanceof Queue) {
            Queue queue = (Queue)collection;
            return queue.peek();
        }
        if (collection instanceof Deque) {
            Deque deque = (Deque)collection;
            return deque.peekFirst();
        }
        if (collection instanceof SortedSet) {
            SortedSet set = (SortedSet)collection;
            return set.first();
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return list.get(0);
        }
        Iterator<E> it = collection.iterator();
        return it.hasNext() ? (E)it.next() : null;
    }

    public static <E> Set<E> diff(Set<?> a, Set<?> b) {
        HashSet result = new HashSet();
        for (Object e : a) {
            if (b.contains(e)) continue;
            result.add(e);
        }
        for (Object e : b) {
            if (a.contains(e)) continue;
            result.add(e);
        }
        return CollectionUtils.castSet(result);
    }

    public static boolean identical(Set<?> a, Set<?> b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.size() == b.size() && a.containsAll(b) && b.containsAll(a);
    }

    public static <T> T getItem(Collection<T> col, int index) {
        if (col == null) {
            throw new NullPointerException("Supplied collection is null");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Supplied index is negative");
        }
        if (col instanceof List) {
            return CollectionUtils.castList(col).get(index);
        }
        if (index >= col.size()) {
            throw new IndexOutOfBoundsException("Index is out of bounds");
        }
        Iterator<T> it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            T val = it.next();
            if (i == index) {
                return val;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException("Index is out of bounds");
    }

    public static <T> Collection<T> castCollection(Object o) {
        return (Collection)o;
    }

    public static <T> Enumeration<T> castEnumeration(Object o) {
        return (Enumeration)o;
    }

    public static <T> Iterator<T> castIterator(Object o) {
        return (Iterator)o;
    }

    public static <T> List<T> castList(Object o) {
        return (List)o;
    }

    public static <T> Set<T> castSet(Object o) {
        return (Set)o;
    }

    public static <T, V> Collection<V> apply(Collection<T> collection, Function<T, V> function) {
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(function.eval(t));
        }
        return list;
    }

    public static <T, V> V bestValue(Collection<T> collection, Function<T, V> function, Comparator<V> comparator) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Iterator<T> i = collection.iterator();
        V candidateValue = function.eval(i.next());
        while (i.hasNext()) {
            V nextValue = function.eval(i.next());
            if (comparator.compare(candidateValue, nextValue) >= 0) continue;
            candidateValue = nextValue;
        }
        return candidateValue;
    }

    public static <V> Comparator<V> lt() {
        Comparator<?> comparator = LT;
        return comparator;
    }

    public static <V> Comparator<V> gt() {
        Comparator<?> comparator = GT;
        return comparator;
    }

    public static interface Function<T, V> {
        public V eval(T var1);
    }

    public static class NegativeComparator<V>
    implements Comparator<V> {
        @Override
        public int compare(V o1, V o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return -((Comparable)o1).compareTo(o2);
        }
    }

    public static class PositiveComparator<V>
    implements Comparator<V> {
        @Override
        public int compare(V o1, V o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }

    private static final class EmptyCollection
    extends AbstractCollection<Object>
    implements RandomAccess,
    Serializable {
        static final long serialVersionUID = -1094618817569532562L;

        private EmptyCollection() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public Iterator<Object> iterator() {
            return EMPTY_ITERATOR;
        }

        @Contract(value={Serializable.class})
        private Object readResolve() {
            return EMPTY_COLLECTION;
        }
    }
}

