/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.string;

import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ParserUtils {
    private ParserUtils() {
    }

    public static char charAt(CharSequence in, int p) {
        return p < in.length() ? in.charAt(p) : (char)'\uffff';
    }

    public static boolean startsWith(char[] a, int p, String b) {
        return ParserUtils.startsWith(a, p, b.toCharArray());
    }

    public static boolean startsWith(char[] a, int p, char ... b) {
        if (a == null || b == null || b.length == 0 || a.length - p < b.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (a[p + i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int skip(char[] a, int p, char ... b) {
        int q = p;
        boolean skip = true;
        while (skip && q < a.length) {
            skip = false;
            char c = a[q];
            for (int i = 0; i < b.length && !skip; ++i) {
                if (c != b[i]) continue;
                skip = true;
            }
            if (!skip) continue;
            ++q;
        }
        return q;
    }

    public static int skipWhitespace(char[] a, int p) {
        return ParserUtils.skip(a, p, ' ', '\n', '\r', '\t');
    }

    public static int countChars(char[] a, int p, char c) {
        int cnt = 0;
        for (int i = p; i < a.length && a[i] == c; ++i) {
            ++cnt;
        }
        return cnt;
    }

    public static int backtrack(char[] a, int p, char ... b) {
        if (p - b.length < 0) {
            return p;
        }
        return ParserUtils.startsWith(a, p - b.length, b) ? p - b.length : p;
    }

    public static int find(char[] a, int p, String b) {
        return ParserUtils.find(a, p, b.toCharArray());
    }

    public static int find(char[] a, int p, char ... b) {
        for (int i = p; i < a.length; ++i) {
            if (a[i] != b[0] || !ParserUtils.startsWith(a, i, b)) continue;
            return i;
        }
        return -1;
    }

    public static int scanToken(String string, String delim, int start) {
        int p = string.length();
        for (int i = delim.length() - 1; i > -1; --i) {
            int q = string.indexOf(delim.charAt(i), start);
            if (q <= -1 || q >= p) continue;
            p = q;
        }
        return p == string.length() ? -1 : p;
    }
}

