/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int read() throws IOException {
        return this.buffer.get();
    }

    @Override
    public synchronized int read(byte[] buf, int offset, int length) throws IOException {
        int l = Math.min(length, this.buffer.remaining());
        this.buffer.get(buf, offset, l);
        return l;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
    }
}

