/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.reference;

import uk.org.retep.util.reference.CleanableWeakReference;
import uk.org.retep.util.reference.ReferenceFactory;
import uk.org.retep.util.thread.DelayedRunnableAdaptor;

public abstract class AbstractDelayedWeakReference<T>
extends CleanableWeakReference<T> {
    public static final long DEFAULT_TIMEOUT = 10000L;
    private long timeout;
    private T o;
    private long touched;
    private DelayedRunnableAdaptor task;

    public AbstractDelayedWeakReference(T o) {
        this(10000L, o);
    }

    public AbstractDelayedWeakReference(long timeout, T o) {
        super(o);
        this.timeout = timeout;
        this.o = o;
    }

    @Override
    public void cleanupReference() {
        if (this.o != null) {
            long unused = System.currentTimeMillis() - this.touched;
            if (unused > this.timeout / 2L) {
                this.o = null;
                this.touched = 0L;
                this.unschedule();
            } else {
                this.schedule(this.timeout - (long)((int)unused));
            }
        } else {
            this.remove(super.get());
        }
    }

    protected abstract void remove(T var1);

    @Override
    public synchronized T get() {
        if (this.o == null) {
            this.o = super.get();
        }
        if (this.o != null) {
            if (this.touched == 0L) {
                this.schedule(this.timeout);
            }
            this.touched = System.currentTimeMillis();
            return this.o;
        }
        return null;
    }

    private final synchronized void schedule(long delay) {
        if (this.task == null) {
            this.task = new DelayedRunnableAdaptor(){

                @Override
                public void run() {
                    AbstractDelayedWeakReference.this.cleanupReference();
                }
            };
        } else {
            this.task.setDelay(delay);
        }
        ReferenceFactory.getDelayThreadPoolExecutor().execute(this.task);
    }

    private final synchronized void unschedule() {
        if (this.task != null) {
            ReferenceFactory.getDelayThreadPoolExecutor().remove(this.task);
        }
    }
}

