/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.graphics;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import uk.org.retep.swing.model.EnumModel;
import uk.org.retep.util.graphics.GeomUtils;
import uk.org.retep.util.string.StringUtils;

public enum Shapes implements EnumModel.Renderable
{
    CIRCLE,
    CLOUD,
    DIAMOND,
    ELLIPSE,
    ROUND_SQUARE,
    STAR,
    SQUARE;


    public Rectangle fit(int x, int y, int w, int h) {
        return this.fit(new Rectangle(x, y, w, h));
    }

    public Rectangle fit(double x, double y, double w, double h) {
        return this.fit(GeomUtils.createRectangle(x, y, w, h));
    }

    public Rectangle fit(Rectangle bounds) {
        switch (this) {
            default: {
                return bounds;
            }
            case ROUND_SQUARE: {
                return GeomUtils.createRectangle(bounds.getX() - 10.0, bounds.getY() - 10.0, bounds.getWidth() + 20.0, bounds.getHeight() + 20.0);
            }
            case CIRCLE: {
                return GeomUtils.fitCircle(bounds);
            }
            case CLOUD: 
            case ELLIPSE: {
                return GeomUtils.fitEllipse(bounds);
            }
            case STAR: 
        }
        double d = Math.max(bounds.getWidth(), bounds.getHeight()) / 2.0;
        return GeomUtils.createRectangle(bounds.getX() - d, bounds.getY() - d, bounds.getWidth() + d, bounds.getHeight() + d);
    }

    public Point2D intersect(Rectangle bounds, Point2D point) {
        Point2D centre = GeomUtils.getCentre(bounds);
        Line2D.Double line = new Line2D.Double(point, centre);
        Shape shape = this.getShape(bounds);
        return GeomUtils.findIntersection((Line2D)line, shape);
    }

    public Shape getShape(Rectangle bounds) {
        switch (this) {
            default: {
                return bounds;
            }
            case ROUND_SQUARE: {
                return new RoundRectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 20.0, 20.0);
            }
            case CIRCLE: 
            case ELLIPSE: {
                return GeomUtils.createEllipse2D(bounds);
            }
            case CLOUD: {
                return this.cloudShape(bounds);
            }
            case STAR: 
        }
        return this.starShape(bounds);
    }

    private Shape cloudShape(Rectangle bounds) {
        double x0 = bounds.getX() + bounds.getWidth() / 2.0;
        double y0 = bounds.getY() + bounds.getHeight() / 2.0;
        double r1 = bounds.getWidth() / 4.0;
        double r2 = bounds.getHeight() / 4.0;
        double r3 = 2.0 * r1;
        double r4 = 2.0 * r2;
        double dx = Math.abs(r1 * Math.sin(0.7853981633974483)) / 1.5;
        double dy = Math.abs(r2 * Math.cos(0.7853981633974483)) / 1.5;
        double[] cx = new double[8];
        double[] cy = new double[8];
        cx[0] = x0 - r1;
        cy[0] = y0;
        cx[1] = x0 - dx;
        cy[1] = y0 + dx;
        cx[2] = x0;
        cy[2] = y0 - r2;
        cx[3] = x0 + dx;
        cy[3] = y0 + dx;
        cx[4] = x0 + r1;
        cy[4] = y0;
        cx[5] = x0 + dx;
        cy[5] = y0 - dx;
        cx[6] = x0;
        cy[6] = y0 + r2;
        cx[7] = x0 - dx;
        cy[7] = y0 - dx;
        Area area = new Area();
        for (int i = 0; i < cx.length; ++i) {
            Ellipse2D.Double circle = new Ellipse2D.Double(cx[i] - r1, cy[i] - r2, r3, r4);
            area.add(new Area(circle));
        }
        return area;
    }

    private Shape starShape(Rectangle bounds) {
        GeneralPath p = new GeneralPath();
        float x0 = (float)bounds.getX();
        float y0 = (float)bounds.getY();
        float w = (float)bounds.getWidth();
        float h = (float)bounds.getHeight();
        float x1 = x0 + w;
        float y1 = y0 + h;
        float cx = x0 + w / 2.0f;
        float cy = y0 + h / 2.0f;
        float x3 = x0 + w / 6.0f;
        float x4 = x1 - w / 6.0f;
        float x5 = x0 + w / 4.0f;
        float x6 = x1 - w / 4.0f;
        float y2 = y0 + h / 4.0f;
        float y3 = y1 - h / 4.0f;
        p.moveTo(x0, y2);
        p.lineTo(x5, y2);
        p.lineTo(cx, y0);
        p.lineTo(x6, y2);
        p.lineTo(x1, y2);
        p.lineTo(x4, cy);
        p.lineTo(x1, y1);
        p.lineTo(cx, y3);
        p.lineTo(x0, y1);
        p.lineTo(x3, cy);
        p.closePath();
        return p;
    }

    @Override
    public String getDescription() {
        return StringUtils.capitaliseEnum(this.toString());
    }

    @Override
    public void render(Graphics2D g, int w, int h) {
        Rectangle r;
        switch (this) {
            case ELLIPSE: {
                r = new Rectangle(4, 4 + (h >> 3), w - 8, h - 8 - (h >> 2));
                break;
            }
            default: {
                r = new Rectangle(4, 4, w - 8, h - 8);
            }
        }
        g.draw(this.getShape(r));
    }
}

