/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.messaging;

import java.util.Collection;
import uk.org.retep.util.messaging.Component;
import uk.org.retep.util.messaging.Message;
import uk.org.retep.util.messaging.MessageException;
import uk.org.retep.util.messaging.Router;

public final class MessagingService<K, R> {
    private final Router<K, R> router;

    public MessagingService(Router<K, R> router) throws MessageException {
        this.router = router;
        router.setMessagingService(this);
    }

    public boolean addRoute(R route, Component<K, ?> component) throws MessageException {
        return this.router.addRoute(route, component);
    }

    public boolean removeRoute(R route) {
        return this.router.removeRoute(route);
    }

    public boolean removeComponent(Component<K, ?> component) {
        return this.router.removeComponent(component);
    }

    public Collection<R> getRoutes() {
        return this.router.getRoutes();
    }

    public Collection<Component<K, ?>> getComponents() {
        return this.router.getComponents();
    }

    public void send(Message<K> message) throws MessageException {
        this.router.consume(message);
    }

    public void startService() throws MessageException {
        this.router.startComponent();
    }

    public void stopService() {
        this.router.stopComponent();
    }

    public boolean isServiceStarted() {
        return this.router.isComponentStarted();
    }
}

