/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.lzma;

import java.io.IOException;
import java.io.InputStream;

class RangeDecoder {
    private static final int kTopMask = -16777216;
    private static final int kNumBitModelTotalBits = 11;
    private static final int kBitModelTotal = 2048;
    private static final int kNumMoveBits = 5;
    private int range;
    private int code;
    private InputStream stream;

    RangeDecoder() {
    }

    public final void setStream(InputStream stream) {
        this.stream = stream;
    }

    public final void releaseStream() {
        this.stream = null;
    }

    public final void init() throws IOException {
        this.code = 0;
        this.range = -1;
        for (int i = 0; i < 5; ++i) {
            this.code = this.code << 8 | this.stream.read();
        }
    }

    public final int decodeDirectBits(int numTotalBits) throws IOException {
        int result = 0;
        for (int i = numTotalBits; i != 0; --i) {
            this.range >>>= 1;
            int t = this.code - this.range >>> 31;
            this.code -= this.range & t - 1;
            result = result << 1 | 1 - t;
            if ((this.range & 0xFF000000) != 0) continue;
            this.code = this.code << 8 | this.stream.read();
            this.range <<= 8;
        }
        return result;
    }

    public int decodeBit(short[] probs, int index) throws IOException {
        short prob = probs[index];
        int newBound = (this.range >>> 11) * prob;
        if ((this.code ^ Integer.MIN_VALUE) < (newBound ^ Integer.MIN_VALUE)) {
            this.range = newBound;
            probs[index] = (short)(prob + (2048 - prob >>> 5));
            if ((this.range & 0xFF000000) == 0) {
                this.code = this.code << 8 | this.stream.read();
                this.range <<= 8;
            }
            return 0;
        }
        this.range -= newBound;
        this.code -= newBound;
        probs[index] = (short)(prob - (prob >>> 5));
        if ((this.range & 0xFF000000) == 0) {
            this.code = this.code << 8 | this.stream.read();
            this.range <<= 8;
        }
        return 1;
    }

    public static void initBitModels(short[] probs) {
        for (int i = 0; i < probs.length; ++i) {
            probs[i] = 1024;
        }
    }
}

