/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.xml;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.jcip.annotations.ThreadSafe;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.Unsafe;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.collections.queue.BoundedLinkedList;
import uk.org.retep.util.concurrent.ConcurrencySupport;
import uk.org.retep.util.xml.jaxb.MarshallerFacade;
import uk.org.retep.util.xml.jaxb.UnmarshallerFacade;

@ThreadSafe
public class JAXBUtil
extends ConcurrencySupport {
    private static final AtomicLong PACKAGE_SERIAL_ID = new AtomicLong();
    private final Set<String> packages = new HashSet<String>();
    private JAXBContext context;
    private MarshallerCallback marshallerCallback;
    private UnmarshallerCallback unmarshallerCallback;
    private Queue<UnmarshallerWrapper> unmarshallerQueue;
    private Queue<MarshallerWrapper> marshallerQueue = new LinkedList<MarshallerWrapper>();
    private int poolSize = 0;
    private ClassLoader classLoader;
    private long packageSerialId;

    public JAXBUtil() {
        this.unmarshallerQueue = new LinkedList<UnmarshallerWrapper>();
        this.clear();
    }

    public JAXBUtil(String ... packages) {
        this();
        for (String pkg : packages) {
            this.addPackage(pkg);
        }
    }

    public JAXBUtil(ArrayList<String> packages) {
        this();
        for (String pkg : packages) {
            this.addPackage(pkg);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void clear() {
        this.writeLock().lock();
        try {
            this.context = null;
            this.marshallerQueue.clear();
            this.unmarshallerQueue.clear();
            this.packageSerialId = PACKAGE_SERIAL_ID.incrementAndGet();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void addPackage(String ... pkg) {
        this.writeLock().lock();
        try {
            try {
                for (String p : pkg) {
                    this.packages.add(p);
                }
            }
            finally {
                this.clear();
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void addPackage(String pkg) {
        this.writeLock().lock();
        try {
            try {
                if (pkg.contains(":")) {
                    for (String p : pkg.split(":")) {
                        this.packages.add(p);
                    }
                } else {
                    this.packages.add(pkg);
                }
            }
            finally {
                this.clear();
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public void addPackage(Package ... packages) {
        for (Package pkg : packages) {
            this.addPackage(pkg.getName());
        }
    }

    public void addPackage(Class<?> clazz) {
        this.addPackage(clazz.getPackage());
    }

    public void addPackages(Class<?> clazz) {
        this.addPackages(clazz.getPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void addPackages(Package pkg) {
        this.writeLock().lock();
        try {
            if (pkg == null) {
                throw new IllegalArgumentException("Package may not be null");
            }
            try {
                String name = pkg.getName();
                for (Package p : Package.getPackages()) {
                    if (!p.getName().startsWith(name)) continue;
                    this.packages.add(p.getName());
                }
            }
            finally {
                this.clear();
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public void addSubPackages(String name) {
        this.addPackages(JAXBUtil.findPackage(name));
    }

    private static Package findPackage(String name) {
        String pkgName = name;
        Package pkg = Package.getPackage(pkgName);
        while (pkgName.length() > 0 && pkg == null) {
            int i = pkgName.lastIndexOf(46);
            if ((pkgName = i > -1 ? pkgName.substring(0, i) : "").length() <= 0) continue;
            pkg = Package.getPackage(pkgName);
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void removePackage(String ... pkg) {
        this.writeLock().lock();
        try {
            try {
                for (String p : pkg) {
                    this.packages.remove(p);
                }
            }
            finally {
                this.clear();
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void removePackage(String pkg) {
        this.writeLock().lock();
        try {
            try {
                if (pkg.contains(":")) {
                    for (String p : pkg.split(":")) {
                        this.packages.remove(p);
                    }
                } else {
                    this.packages.remove(pkg);
                }
            }
            finally {
                this.clear();
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public void removePackage(Package pkg) {
        this.removePackage(pkg.getName());
    }

    public void removePackage(Class<?> clazz) {
        this.removePackage(clazz.getPackage());
    }

    public void removePackages(Class<?> clazz) {
        this.removeSubPackages(clazz.getPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void removeSubPackages(Package pkg) {
        this.writeLock().lock();
        try {
            if (pkg == null) {
                throw new IllegalArgumentException("Package may not be null");
            }
            try {
                String name = pkg.getName();
                for (Package p : Package.getPackages()) {
                    if (!p.getName().startsWith(name)) continue;
                    this.packages.remove(p.getName());
                }
            }
            finally {
                this.clear();
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public void removePackages(String name) {
        this.removeSubPackages(JAXBUtil.findPackage(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    @Unsafe
    public JAXBContext getJAXBContext() throws JAXBException {
        this.writeLock().lock();
        try {
            if (this.context == null) {
                this.getLog().info("Creating JAXBContext");
                boolean notFirst = false;
                StringBuilder path = new StringBuilder();
                for (String pkg : this.packages) {
                    if (notFirst) {
                        path.append(':');
                    } else {
                        notFirst = true;
                    }
                    path.append(pkg);
                }
                this.context = this.classLoader == null ? JAXBContext.newInstance((String)path.toString()) : JAXBContext.newInstance((String)path.toString(), (ClassLoader)this.classLoader);
            }
            JAXBContext jAXBContext = this.context;
            return jAXBContext;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureMarshallerPoolSize(int size) throws JAXBException {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        int remaining = 0;
        do {
            this.release(this.createMarshaller());
            this.readLock().lock();
            try {
                remaining = this.poolSize == 0 ? size : Math.min(this.poolSize, size);
            }
            finally {
                this.readLock().unlock();
            }
        } while ((remaining -= this.marshallerQueue.size()) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureUnmarshallerPoolSize(int size) throws JAXBException {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        int remaining = 0;
        do {
            this.release(this.createUnmarshaller());
            this.readLock().lock();
            try {
                remaining = this.poolSize == 0 ? size : Math.min(this.poolSize, size);
            }
            finally {
                this.readLock().unlock();
            }
        } while ((remaining -= this.unmarshallerQueue.size()) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void setPoolSize(int poolSize) {
        this.writeLock().lock();
        try {
            if (this.poolSize == poolSize) {
                return;
            }
            LinkedList<UnmarshallerWrapper> newUnmarshallerQueue = null;
            LinkedList<MarshallerWrapper> newMarshallerQueue = null;
            if (poolSize < 1) {
                this.poolSize = 0;
                newUnmarshallerQueue = new LinkedList<UnmarshallerWrapper>();
                newMarshallerQueue = new LinkedList<MarshallerWrapper>();
            } else {
                this.poolSize = poolSize;
                newUnmarshallerQueue = new BoundedLinkedList(poolSize);
                newMarshallerQueue = new BoundedLinkedList(poolSize);
            }
            for (UnmarshallerWrapper unmarshaller : this.unmarshallerQueue) {
                newUnmarshallerQueue.offer(unmarshaller);
            }
            for (MarshallerWrapper marshaller : this.marshallerQueue) {
                newMarshallerQueue.offer(marshaller);
            }
            this.unmarshallerQueue = newUnmarshallerQueue;
            this.marshallerQueue = newMarshallerQueue;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    private Marshaller pollMarshaller() {
        this.writeLock().lock();
        try {
            Marshaller marshaller = this.marshallerQueue.poll();
            return marshaller;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public Marshaller getMarshaller() throws JAXBException {
        Marshaller marshaller = this.pollMarshaller();
        if (marshaller == null) {
            marshaller = this.createMarshaller();
        }
        return marshaller;
    }

    private Marshaller createMarshaller() throws JAXBException {
        this.getLog().info("Creating Marshaller");
        MarshallerWrapper marshaller = new MarshallerWrapper();
        if (this.marshallerCallback != null) {
            this.marshallerCallback.initialiseMarshaller(marshaller, this);
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    private Unmarshaller pollUnmarshaller() {
        this.writeLock().lock();
        try {
            Unmarshaller unmarshaller = this.unmarshallerQueue.poll();
            return unmarshaller;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public Unmarshaller getUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.pollUnmarshaller();
        if (unmarshaller == null) {
            unmarshaller = this.createUnmarshaller();
        }
        return unmarshaller;
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        this.getLog().info("Creating Unmarshaller");
        UnmarshallerWrapper unmarshaller = new UnmarshallerWrapper();
        if (this.unmarshallerCallback != null) {
            this.unmarshallerCallback.initialiseUnmarshaller(unmarshaller, this);
        }
        return unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public boolean release(Marshaller marshaller) {
        this.writeLock().lock();
        try {
            MarshallerWrapper wrapper;
            if (marshaller instanceof MarshallerWrapper && (wrapper = (MarshallerWrapper)MarshallerWrapper.class.cast(marshaller)).getPackageSerialId() == this.packageSerialId) {
                boolean bl = this.marshallerQueue.offer(wrapper);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public boolean release(Unmarshaller unmarshaller) {
        this.writeLock().lock();
        try {
            UnmarshallerWrapper wrapper;
            if (unmarshaller instanceof UnmarshallerWrapper && (wrapper = (UnmarshallerWrapper)UnmarshallerWrapper.class.cast(unmarshaller)).getPackageSerialId() == this.packageSerialId) {
                boolean bl = this.unmarshallerQueue.offer(wrapper);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public static <T> JAXBElement<T> getJAXBElement(Object o) {
        return (JAXBElement)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    public MarshallerCallback getMarshallerCallback() {
        this.readLock().lock();
        try {
            MarshallerCallback marshallerCallback = this.marshallerCallback;
            return marshallerCallback;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void setMarshallerCallback(MarshallerCallback marshallerCallback) {
        this.writeLock().lock();
        try {
            this.marshallerCallback = marshallerCallback;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    public UnmarshallerCallback getUnmarshallerCallback() {
        this.readLock().lock();
        try {
            UnmarshallerCallback unmarshallerCallback = this.unmarshallerCallback;
            return unmarshallerCallback;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public void setUnmarshallerCallback(UnmarshallerCallback unmarshallerCallback) {
        this.writeLock().lock();
        try {
            this.unmarshallerCallback = unmarshallerCallback;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshall(Object object, ContentHandler out) throws JAXBException {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(object, out);
        }
        finally {
            this.release(marshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshall(Object object, File out) throws JAXBException {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(object, out);
        }
        finally {
            this.release(marshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshall(Object object, Node out) throws JAXBException {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(object, out);
        }
        finally {
            this.release(marshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshall(Object object, OutputStream out) throws JAXBException {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(object, out);
        }
        finally {
            this.release(marshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshall(Object object, Result out) throws JAXBException {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(object, out);
        }
        finally {
            this.release(marshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshall(Object object, Writer out) throws JAXBException {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(object, out);
        }
        finally {
            this.release(marshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshall(Object object, XMLEventWriter out) throws JAXBException {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(object, out);
        }
        finally {
            this.release(marshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshall(Object object, XMLStreamWriter out) throws JAXBException {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(object, out);
        }
        finally {
            this.release(marshaller);
        }
    }

    public String marshall(Object object) throws JAXBException {
        StringWriter sw = new StringWriter();
        this.marshall(object, sw);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshall(File in) throws JAXBException {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object object = unmarshaller.unmarshal(in);
            return (T)object;
        }
        finally {
            this.release(unmarshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshall(InputSource in) throws JAXBException {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object object = unmarshaller.unmarshal(in);
            return (T)object;
        }
        finally {
            this.release(unmarshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshall(InputStream in) throws JAXBException {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object object = unmarshaller.unmarshal(in);
            return (T)object;
        }
        finally {
            this.release(unmarshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshall(Node in) throws JAXBException {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object object = unmarshaller.unmarshal(in);
            return (T)object;
        }
        finally {
            this.release(unmarshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshall(Reader in) throws JAXBException {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object object = unmarshaller.unmarshal(in);
            return (T)object;
        }
        finally {
            this.release(unmarshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshall(Source in) throws JAXBException {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object object = unmarshaller.unmarshal(in);
            return (T)object;
        }
        finally {
            this.release(unmarshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshall(URL in) throws JAXBException {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object object = unmarshaller.unmarshal(in);
            return (T)object;
        }
        finally {
            this.release(unmarshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshall(XMLEventReader in) throws JAXBException {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object object = unmarshaller.unmarshal(in);
            return (T)object;
        }
        finally {
            this.release(unmarshaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshall(XMLStreamReader in) throws JAXBException {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object object = unmarshaller.unmarshal(in);
            return (T)object;
        }
        finally {
            this.release(unmarshaller);
        }
    }

    public <T> T unmarshall(String in) throws JAXBException {
        return this.unmarshall(new StringReader(in));
    }

    private class UnmarshallerWrapper
    extends UnmarshallerFacade {
        private final long packageSerialId;

        public UnmarshallerWrapper() throws JAXBException {
            super(JAXBUtil.this.getJAXBContext().createUnmarshaller());
            this.packageSerialId = JAXBUtil.this.packageSerialId;
        }

        public final long getPackageSerialId() {
            return this.packageSerialId;
        }
    }

    private class MarshallerWrapper
    extends MarshallerFacade {
        private final long packageSerialId;

        public MarshallerWrapper() throws JAXBException {
            super(JAXBUtil.this.getJAXBContext().createMarshaller());
            this.packageSerialId = JAXBUtil.this.packageSerialId;
        }

        public final long getPackageSerialId() {
            return this.packageSerialId;
        }
    }

    public static interface UnmarshallerCallback {
        public void initialiseUnmarshaller(Unmarshaller var1, JAXBUtil var2) throws PropertyException;
    }

    public static interface MarshallerCallback {
        public void initialiseMarshaller(Marshaller var1, JAXBUtil var2) throws PropertyException;
    }
}

