/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.tree;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.org.retep.util.tree.AbstractTreeNode;
import uk.org.retep.util.tree.PropertySet;

public class StringTree {
    private Node root;
    private int depth;
    private int hashCode;

    public StringTree() {
    }

    public StringTree(String s) {
        this.parse(s);
    }

    public void parse(String s) {
        Iterator it;
        this.parse(null, this.fix(s, "[\\)|\\(]", "[\\]|\\[]").trim(), 0);
        if (this.root.getLabel().length() == 0 && this.root.getProperties().isEmpty() && this.root.getChildren().size() == 1 && (it = this.root.getChildren().iterator()).hasNext()) {
            this.root = (Node)this.root.removeChild((AbstractTreeNode)it.next());
        }
    }

    private String fix(String s, String ... p) {
        for (String pt : p) {
            Pattern pat = Pattern.compile("(" + pt + ")?[\n|\t|\r| ]+(" + pt + ")?");
            Matcher mat = pat.matcher(s);
            StringBuffer sb = new StringBuffer();
            while (mat.find()) {
                String r1 = mat.group(1);
                String r2 = mat.group(2);
                String r = r1 == null && r2 == null ? " " : (r1 == null ? "" : r1) + (r2 == null ? "" : r2);
                mat.appendReplacement(sb, r);
            }
            mat.appendTail(sb);
            s = sb.toString();
        }
        return s;
    }

    private int parse(Node parent, String s, int p) {
        Node node = new Node();
        if (parent == null) {
            this.root = node;
        } else {
            parent.addChild(node);
        }
        StringBuilder sb = new StringBuilder();
        while (p < s.length()) {
            char c = s.charAt(p);
            switch (c) {
                case '(': {
                    p = this.parse(node, s, p + 1);
                    break;
                }
                case ')': {
                    node.setText(sb.toString());
                    return p;
                }
                case '\\': {
                    if (p + 1 >= s.length()) break;
                    sb.append(s.charAt(++p));
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++p;
        }
        node.setText(sb.toString());
        return p;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getDepth() {
        return this.root == null ? -1 : this.root.getDepth();
    }

    public static String trimWhitespace(String text) {
        return text == null ? "" : text.replaceAll("[\n| |\t|\r]+", " ").trim();
    }

    public int hashCode() {
        if (this.hashCode == 0 && this.root != null) {
            this.hashCode = this.root.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringTree) {
            StringTree b = (StringTree)obj;
            if (this.root == null) {
                return b.root == null;
            }
            return this.root.equals(b.root);
        }
        return false;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }

    public StringBuilder append(StringBuilder sb) {
        if (this.root != null) {
            this.root.append(sb);
        }
        return sb;
    }

    public class Node
    extends AbstractTreeNode<Node> {
        private PropertySet prop = new PropertySet();

        public String getLabel() {
            return this.prop.getLabel();
        }

        public PropertySet getProperties() {
            return this.prop;
        }

        public void setText(String text) {
            this.prop.setText(text);
            this.childModified();
        }

        @Override
        protected int hashCodeImpl() {
            return this.prop.hashCode();
        }

        @Override
        protected boolean equalsImpl(Node node) {
            return this.prop.equals(node.prop);
        }

        @Override
        protected void appendImpl(StringBuilder sb) {
            sb.append(this.prop);
        }
    }
}

