/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.logging;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import uk.org.retep.logging.Log;
import uk.org.retep.logging.LogFactory;

public class Log4JHandler
extends Handler {
    private Map<String, Log> loggers = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public void publish(LogRecord rec) {
        Log log = this.loggers.get(rec.getLoggerName());
        if (log == null) {
            log = LogFactory.getLog(rec.getLoggerName(), new Object[0]);
            this.loggers.put(rec.getLoggerName(), log);
        }
        String msg = rec.getMessage();
        Level level = rec.getLevel();
        if (level == Level.INFO || level == Level.ALL) {
            log.info(msg);
        } else if (level == Level.WARNING) {
            log.warn(msg);
        } else if (level == Level.SEVERE) {
            log.error(msg);
        } else {
            log.debug(msg);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.loggers.clear();
    }
}

