/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import uk.org.retep.util.collections.ConcurrencySupport;
import uk.org.retep.util.thread.GlobalThreadPool;

public abstract class SocketProcessor
extends ConcurrencySupport
implements Runnable {
    private ServerSocketChannel serverChannel;
    private ServerSocket serverSocket;
    private InetSocketAddress socketAddress;
    private NetworkInterface networkInterface;
    private Selector selector;
    private boolean running;
    private Queue<RegisteredChannel> registerQueue = new ConcurrentLinkedQueue<RegisteredChannel>();

    public final void start() throws IOException {
        if (this.isRunning()) {
            return;
        }
        if (this.selector == null) {
            this.selector = Selector.open();
        }
        this.startImpl();
        Thread thread = GlobalThreadPool.createDaemonThread(this.getClass().getName(), this);
        thread.start();
    }

    protected abstract void startImpl() throws IOException;

    public final void stop() {
        if (this.isRunning()) {
            this.running = false;
            if (this.selector != null) {
                this.selector.wakeup();
            }
            this.stopImpl();
        }
    }

    protected abstract void stopImpl();

    public final InetAddress getLocalInetAddress() throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            this.getLog().debug("UP:%s, LB:%s, Virt:%s P2P:%s %s", ni.isUp(), ni.isLoopback(), ni.isVirtual(), ni.isPointToPoint(), ni);
            if (!ni.isUp() || ni.isLoopback() || ni.isVirtual()) continue;
            Enumeration<InetAddress> eia = ni.getInetAddresses();
            while (eia.hasMoreElements()) {
                InetAddress address = eia.nextElement();
                if (address.isMulticastAddress() || address.getAddress().length != 4) continue;
                return address;
            }
        }
        return null;
    }

    public final InetAddress getInetAddress(String addr) throws SocketException, UnknownHostException {
        Enumeration<InetAddress> eia;
        NetworkInterface ni = NetworkInterface.getByName(addr);
        if (ni != null && ni.isUp() && (eia = ni.getInetAddresses()).hasMoreElements()) {
            return eia.nextElement();
        }
        return InetAddress.getByName(addr);
    }

    public final void bind(SocketAddress endPoint) throws IOException {
        if (endPoint == null) {
            endPoint = new InetSocketAddress(this.getLocalInetAddress(), 0);
        }
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        this.serverSocket = this.serverChannel.socket();
        this.serverSocket.bind(endPoint);
        this.networkInterface = NetworkInterface.getByInetAddress(this.serverSocket.getInetAddress());
        this.getLog().info("\n----------------------------------------------------------------------\n%s: %s|%d on %s\n----------------------------------------------------------------------", this.getClass().getSimpleName(), this.serverSocket.getInetAddress().getHostAddress(), this.serverSocket.getLocalPort(), this.networkInterface == null ? "Unknown" : this.networkInterface.getName());
        this.getLog().info("Now receiving accept");
    }

    protected final void registerChannelImpl(SelectableChannel channel, int selectionOps, Object attachment) throws ClosedChannelException, IOException {
        if (channel == null || this.selector == null) {
            return;
        }
        channel.configureBlocking(false);
        channel.register(this.selector, selectionOps, attachment);
    }

    protected final void registerChannelImpl(SelectableChannel channel, int selectionOps) throws ClosedChannelException, IOException {
        this.registerChannelImpl(channel, selectionOps, null);
    }

    @Override
    public final void run() {
        if (this.isRunning()) {
            return;
        }
        try {
            if (this.serverChannel != null) {
                this.getLog().debug("Registering selector on serverChannel");
                this.serverChannel.register(this.selector, 16);
            }
        }
        catch (ClosedChannelException ex) {
            this.getLog().error((Object)"Failed to register selector", ex);
            return;
        }
        this.getLog().info("SocketProcessor Thread %s started", Thread.currentThread().getName());
        this.running = true;
        while (this.isRunning()) {
            try {
                int readyCount = this.selector.select();
                if (readyCount > 0) {
                    Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                    while (it.hasNext()) {
                        this.runSelectionKey(it.next());
                        it.remove();
                    }
                }
                RegisteredChannel regChan = this.registerQueue.poll();
                while (regChan != null) {
                    this.registerChannelImpl(regChan.getChannel(), regChan.getSelectionOps(), regChan.getAttachment());
                    regChan = this.registerQueue.poll();
                }
            }
            catch (Exception ex) {
                this.getLog().error("Exception during select() in Thread %s", ex, Thread.currentThread().getName());
            }
        }
        this.getLog().info("SocketProcessor Thread %s stopped", Thread.currentThread().getName());
    }

    private final void runSelectionKey(SelectionKey key) {
        try {
            if (!key.isValid()) {
                this.invalid(key);
            } else if (key.isAcceptable()) {
                this.accept(key);
            } else if (key.isConnectable()) {
                this.connect(key);
            } else if (key.isReadable()) {
                this.read(key);
            } else if (key.isWritable()) {
                this.write(key);
            }
        }
        catch (Exception ex) {
            this.getLog().error((Object)"Exception during select()", ex);
        }
    }

    protected void accept(SelectionKey key) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected void connect(SelectionKey key) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected void read(SelectionKey key) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected void invalid(SelectionKey key) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected void write(SelectionKey key) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected final Selector getSelector() {
        return this.selector;
    }

    public final boolean isRunning() {
        return this.running;
    }

    protected final ServerSocketChannel getServerChannel() {
        return this.serverChannel;
    }

    protected final void setServerChannel(ServerSocketChannel serverChannel) {
        this.serverChannel = serverChannel;
    }

    protected final ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public final InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    protected final void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    protected final void setSocketAddress(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    public final NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public final void registerChannel(SelectableChannel channel, int selectionOps, Object attachment) throws ClosedChannelException, IOException {
        this.registerQueue.add(new RegisteredChannel(channel, selectionOps, attachment));
        this.selector.wakeup();
    }

    public final void registerChannel(SelectableChannel channel, int selectionOps) throws ClosedChannelException, IOException {
        this.registerChannel(channel, selectionOps, null);
    }

    private final class RegisteredChannel {
        final SelectableChannel channel;
        final int selectionOps;
        final Object attachment;

        public RegisteredChannel(SelectableChannel channel, int selectionOps, Object attachment) {
            this.channel = channel;
            this.selectionOps = selectionOps;
            this.attachment = attachment;
        }

        public SelectableChannel getChannel() {
            return this.channel;
        }

        public int getSelectionOps() {
            return this.selectionOps;
        }

        public Object getAttachment() {
            return this.attachment;
        }
    }
}

