/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.org.retep.logging.Log;
import uk.org.retep.util.collections.MapUtils;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.string.PropertyExpansion;
import uk.org.retep.util.string.StringUtils;

public class ResourceInstaller {
    private static final String DEFAULT_MESSAGE = "Installing %s to %s";
    private final Class<?> resourceClass;
    private final File installationDirectory;
    private final String descriptor;
    private final Map<?, ?> properties;
    private final Map<String, String> fileList;
    private Log log;
    private boolean overwrite = true;
    private Hook hook;
    private String message = "Installing %s to %s";

    public ResourceInstaller(Class<?> resourceClass, File installationDirectory, String descriptor) throws IOException {
        this(resourceClass, installationDirectory, descriptor, new HashMap());
    }

    public ResourceInstaller(Class<?> resourceClass, File installationDirectory, String descriptor, Map<?, ?> properties) throws IOException {
        this.resourceClass = resourceClass;
        this.installationDirectory = installationDirectory;
        this.descriptor = descriptor;
        this.properties = properties;
        InputStream is = resourceClass.getResourceAsStream(descriptor);
        this.fileList = MapUtils.loadMap(is, new LinkedHashMap<String, String>());
    }

    public static void install(Class<?> resourceClass, File installationDirectory, String descriptor) throws IOException {
        new ResourceInstaller(resourceClass, installationDirectory, descriptor).install();
    }

    public static void install(Class<?> resourceClass, File installationDirectory, String descriptor, Map<?, ?> properties) throws IOException {
        new ResourceInstaller(resourceClass, installationDirectory, descriptor, properties).install();
    }

    public static void install(Class<?> resourceClass, File installationDirectory, String descriptor, Log log) throws IOException {
        new ResourceInstaller(resourceClass, installationDirectory, descriptor).setLog(log).install();
    }

    public static void install(Class<?> resourceClass, File installationDirectory, String descriptor, Map<?, ?> properties, Log log) throws IOException {
        new ResourceInstaller(resourceClass, installationDirectory, descriptor, properties).setLog(log).install();
    }

    public ResourceInstaller setLog(Log log) {
        this.log = log;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message == null ? DEFAULT_MESSAGE : message;
    }

    private void notice(String msg, Object ... args) {
        if (this.log != null) {
            this.log.info(msg, args);
        }
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public <K, V> Map<K, V> getProperties() {
        return this.properties;
    }

    public void setHook(Hook hook) {
        this.hook = hook;
    }

    public List<File> getDestinationFiles() {
        ArrayList<File> files = new ArrayList<File>(this.fileList.size());
        Map<String, String> map = PropertyExpansion.expandMap(this.fileList, this.properties);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            File file = new File(this.installationDirectory, entry.getValue());
            FileUtils.assertFileInsideDirectory(this.installationDirectory, file);
            files.add(file);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws IOException {
        FileUtils.mkdirs(this.installationDirectory, this.log);
        String installationPath = this.installationDirectory.getAbsolutePath();
        Map<String, String> map = PropertyExpansion.expandMap(this.fileList, this.properties);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            File file = new File(this.installationDirectory, entry.getValue());
            FileUtils.assertFileInsideDirectory(this.installationDirectory, file);
            if (file.exists() && (!this.isOverwrite() || !file.canWrite())) continue;
            String src = entry.getKey();
            InputStream is = this.resourceClass.getResourceAsStream(src);
            if (is == null) {
                throw new IOException("Source resource not found: " + src);
            }
            try {
                this.notice(this.message, StringUtils.baseName(src), file.getPath());
                FileOutputStream fos = new FileOutputStream(file);
                try {
                    if (this.hook != null) {
                        this.hook.preCopy(src, is, fos, file);
                    }
                    FileUtils.copy(is, fos);
                    if (this.hook == null) continue;
                    this.hook.postCopy(src, is, fos, file);
                }
                finally {
                    fos.close();
                }
            }
            finally {
                is.close();
            }
        }
    }

    public static interface Hook {
        public void preCopy(String var1, InputStream var2, OutputStream var3, File var4) throws IOException;

        public void postCopy(String var1, InputStream var2, OutputStream var3, File var4) throws IOException;
    }
}

