/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.queue;

import java.util.List;
import java.util.Queue;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.collections.list.ConcurrentList;

@ThreadSafe
public class ConcurrentQueue<E>
extends ConcurrentList<E>
implements Queue<E> {
    private final Queue<E> queue;

    public ConcurrentQueue(List<E> list) {
        super(list);
        if (!(list instanceof Queue)) {
            throw new ClassCastException("List must also implement Queue");
        }
        this.queue = (Queue)((Object)list);
    }

    public ConcurrentQueue(Queue<E> queue) {
        super(queue instanceof List ? (List)((Object)queue) : null);
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        this.writeLock().lock();
        try {
            boolean bl = this.queue.add(e);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E element() {
        this.readLock().lock();
        try {
            E e = this.queue.element();
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        this.writeLock().lock();
        try {
            boolean bl = this.queue.offer(e);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        this.readLock().lock();
        try {
            E e = this.queue.peek();
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        this.writeLock().lock();
        try {
            E e = this.queue.poll();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove() {
        this.writeLock().lock();
        try {
            E e = this.queue.remove();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }
}

