/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.queue;

import java.util.Collection;
import java.util.concurrent.Executor;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.collections.queue.BoundedLinkedList;
import uk.org.retep.util.collections.queue.ConcurrentDeque;
import uk.org.retep.util.collections.queue.ObjectPool;
import uk.org.retep.util.thread.ExecutorFactory;

@ThreadSafe
public class ConcurrentObjectPool<E extends ObjectPool.Entry>
extends ConcurrentDeque<E>
implements ObjectPool<E> {
    private static final int MIN_CAPACITY = 16;
    private final ObjectPool.Factory<E> factory;

    public ConcurrentObjectPool(Class<E> entryClass) {
        this(entryClass, 100000);
    }

    public ConcurrentObjectPool(Class<E> entryClass, int capacity) {
        this(entryClass, 0, capacity, false);
    }

    public ConcurrentObjectPool(Class<E> entryClass, int initialCapacity, int capacity) {
        this(entryClass, initialCapacity, capacity, true);
    }

    public ConcurrentObjectPool(Class<E> entryClass, int initialCapacity, int capacity, boolean backgroundFill) {
        this(new DefaultFactory<E>(entryClass), initialCapacity, capacity, backgroundFill);
    }

    public ConcurrentObjectPool(ObjectPool.Factory<E> factory) {
        this(factory, 100000);
    }

    public ConcurrentObjectPool(ObjectPool.Factory<E> factory, int capacity) {
        this(factory, 0, capacity, false);
    }

    public ConcurrentObjectPool(ObjectPool.Factory<E> factory, int initialCapacity, int capacity) {
        this(factory, initialCapacity, capacity, true);
    }

    public ConcurrentObjectPool(ObjectPool.Factory<E> factory, int initialCapacity, int capacity, boolean background) {
        this(factory, initialCapacity, capacity, background, ExecutorFactory.getGlobalThreadExecutor());
    }

    public ConcurrentObjectPool(ObjectPool.Factory<E> factory, int initialCapacity, int capacity, boolean background, Executor executor) {
        super(new BoundedLinkedList(capacity));
        this.factory = factory;
        if (capacity < 16) {
            throw new IllegalStateException("capacity out of bounds");
        }
        if (initialCapacity < 0 || initialCapacity > capacity) {
            throw new IllegalStateException("initialCapacity out of bounds");
        }
        if (initialCapacity > 0) {
            this.populatePool(initialCapacity, background, executor);
        }
    }

    @Override
    public void populatePool(int size) {
        this.populatePool(size, false);
    }

    @Override
    public void populatePool(int size, boolean background) {
        this.populatePool(size, background, ExecutorFactory.getGlobalThreadExecutor());
    }

    public void populatePool(final int size, boolean background, Executor executor) {
        if (size <= 0) {
            return;
        }
        if (background && executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    while (ConcurrentObjectPool.this.size() < size && ConcurrentObjectPool.this.offerLast(ConcurrentObjectPool.this.createInstance())) {
                    }
                }
            });
        } else {
            while (this.size() < size && this.offerLast(this.createInstance())) {
            }
        }
    }

    private E createInstance() {
        try {
            return (E)((ObjectPool.Entry)this.factory.createInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        this.writeLock().lock();
        try {
            boolean added = super.add(e);
            if (added) {
                e.instanceReturnedToPool();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E e) {
        this.writeLock().lock();
        try {
            super.add(index, e);
            e.instanceReturnedToPool();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.writeLock().lock();
        try {
            boolean ret = false;
            for (ObjectPool.Entry e : c) {
                try {
                    super.add(index, e);
                    ++index;
                    e.instanceReturnedToPool();
                    ret = true;
                }
                catch (Exception ex) {}
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.writeLock().lock();
        try {
            boolean ret = false;
            for (ObjectPool.Entry e : c) {
                try {
                    if (super.add(e)) {
                        e.instanceReturnedToPool();
                    }
                    ret = true;
                }
                catch (Exception ex) {}
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFirst(E e) {
        this.writeLock().lock();
        try {
            super.addFirst(e);
            e.instanceReturnedToPool();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLast(E e) {
        this.writeLock().lock();
        try {
            super.addLast(e);
            e.instanceReturnedToPool();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        this.writeLock().lock();
        try {
            boolean added = super.offer(e);
            if (added) {
                e.instanceReturnedToPool();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e) {
        this.writeLock().lock();
        try {
            boolean added = super.offerFirst(e);
            if (added) {
                e.instanceReturnedToPool();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e) {
        this.writeLock().lock();
        try {
            boolean added = super.offerLast(e);
            if (added) {
                e.instanceReturnedToPool();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        this.writeLock().lock();
        try {
            ObjectPool.Entry e = (ObjectPool.Entry)super.poll();
            if (e == null) {
                e = this.createInstance();
            }
            ObjectPool.Entry entry = e;
            return (E)entry;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst() {
        this.writeLock().lock();
        try {
            ObjectPool.Entry e = (ObjectPool.Entry)super.pollFirst();
            if (e == null) {
                e = this.createInstance();
            }
            ObjectPool.Entry entry = e;
            return (E)entry;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast() {
        this.writeLock().lock();
        try {
            ObjectPool.Entry e = (ObjectPool.Entry)super.pollLast();
            if (e == null) {
                e = this.createInstance();
            }
            ObjectPool.Entry entry = e;
            return (E)entry;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private static class DefaultFactory<E>
    implements ObjectPool.Factory<E> {
        Class<E> entryClass;

        public DefaultFactory(Class<E> entryClass) {
            this.entryClass = entryClass;
        }

        @Override
        public E createInstance() throws Exception {
            return this.entryClass.newInstance();
        }
    }
}

