/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.thread;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.collections.ConcurrencySupport;

@ThreadSafe
public abstract class ConcurrentDelayedAdaptor
extends ConcurrencySupport
implements Delayed {
    private long triggerTime;

    public ConcurrentDelayedAdaptor() {
        this(0L);
    }

    public ConcurrentDelayedAdaptor(long delay, TimeUnit delayUnit) {
        this.setDelay(delay, delayUnit);
    }

    public ConcurrentDelayedAdaptor(long delay) {
        this.setDelay(delay);
    }

    public final void setTriggerTime(long triggerTime, TimeUnit triggerUnit) {
        this.setTriggerTime(TimeUnit.MILLISECONDS.convert(triggerTime, triggerUnit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public final void setTriggerTime(long triggerTime) {
        this.writeLock().lock();
        try {
            this.triggerTime = triggerTime;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    public final long getTriggerTime() {
        this.readLock().lock();
        try {
            long l = this.triggerTime;
            return l;
        }
        finally {
            this.readLock().unlock();
        }
    }

    public final void setDelay(long delay, TimeUnit delayUnit) {
        this.setDelay(TimeUnit.MILLISECONDS.convert(delay, delayUnit));
    }

    public final void setDelay(long delay) {
        this.setTriggerTime(this.currentTimeMillis() + delay);
    }

    public final long getDelay() {
        return this.getDelay(TimeUnit.MILLISECONDS);
    }

    @Override
    public final int compareTo(Delayed d) {
        return (int)(this.getDelay(TimeUnit.MILLISECONDS) - d.getDelay(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public final long getDelay(TimeUnit unit) {
        this.readLock().lock();
        try {
            long l = unit.convert(this.triggerTime - this.currentTimeMillis(), TimeUnit.MILLISECONDS);
            return l;
        }
        finally {
            this.readLock().unlock();
        }
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

