/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.xml;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.retep.annotations.PrivateThread;
import uk.org.retep.util.collections.ConcurrencySupport;
import uk.org.retep.util.thread.GlobalThreadPool;

public class STaXThread
extends ConcurrencySupport
implements Runnable {
    private static final int DEFAULT_DEPTH = 2;
    private Set<Listener> listeners = new HashSet<Listener>();
    private Listener[] listenerCache;
    private Map<String, String> nameSpaceMap = new HashMap<String, String>();
    private Thread thread = GlobalThreadPool.createDaemonThread("STaX", this);
    private final InputStream inputStream;
    private Document document;
    private Node node;
    private XMLStreamReader xmlStreamReader;
    private boolean running = false;
    private final int triggerDepth;
    private int depth;
    private boolean triggerRootNode = false;
    private int appendDepth = 1;

    public STaXThread(InputStream inputStream) throws ParserConfigurationException, IllegalArgumentException, XMLStreamException, FactoryConfigurationError {
        this(inputStream, 2);
    }

    public STaXThread(InputStream inputStream, int depth) throws ParserConfigurationException, IllegalArgumentException, XMLStreamException, FactoryConfigurationError {
        this.inputStream = inputStream;
        this.triggerDepth = depth;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.document = dbf.newDocumentBuilder().newDocument();
    }

    public boolean isTriggerRootNode() {
        return this.triggerRootNode;
    }

    public void setTriggerRootNode(boolean triggerRootNode) {
        if (this.running) {
            throw new IllegalStateException("Cannot set triggerRootNode once running");
        }
        this.triggerRootNode = triggerRootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(Listener l) {
        this.writeLock().lock();
        try {
            this.listenerCache = null;
            boolean bl = this.listeners.add(l);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(Listener l) {
        this.writeLock().lock();
        try {
            this.listenerCache = null;
            boolean bl = this.listeners.remove(l);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        this.writeLock().lock();
        try {
            this.listenerCache = null;
            this.listeners.clear();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Listener[] listeners() {
        this.readLock().lock();
        try {
            if (this.listenerCache == null) {
                this.listenerCache = this.listeners.toArray(new Listener[this.listeners.size()]);
            }
            Listener[] listenerArray = this.listenerCache;
            return listenerArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNameSpaceSubstitution(String orig, String newValue) {
        this.writeLock().lock();
        try {
            this.nameSpaceMap.put(orig, newValue);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public int getAppendDepth() {
        return this.appendDepth;
    }

    public void setAppendDepth(int appendDepth) {
        if (appendDepth < 1) {
            throw new IllegalArgumentException("appendDepth must be >= 1");
        }
        this.appendDepth = appendDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PrivateThread
    public void run() {
        this.running = true;
        try {
            XMLInputFactory xmlif = XMLInputFactory.newInstance();
            xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            xmlif.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            this.xmlStreamReader = xmlif.createXMLStreamReader(new BufferedInputStream(this.inputStream));
            block10: while (this.running && this.xmlStreamReader.hasNext()) {
                switch (this.xmlStreamReader.next()) {
                    case 1: {
                        String ns;
                        ++this.depth;
                        Element e = null;
                        e = this.xmlStreamReader.getNamespaceURI() == null ? this.document.createElement(this.xmlStreamReader.getLocalName()) : this.document.createElementNS((ns = this.nameSpaceMap.get(this.xmlStreamReader.getNamespaceURI())) == null ? this.xmlStreamReader.getNamespaceURI() : ns, this.xmlStreamReader.getLocalName());
                        e.setPrefix(this.xmlStreamReader.getPrefix());
                        for (int i = 0; i < this.xmlStreamReader.getAttributeCount(); ++i) {
                            e.setAttributeNS(this.xmlStreamReader.getAttributeNamespace(i), this.xmlStreamReader.getAttributeLocalName(i), this.xmlStreamReader.getAttributeValue(i));
                        }
                        if (this.depth > this.appendDepth) {
                            this.node.appendChild(e);
                        }
                        this.node = e;
                        if (!this.triggerRootNode || this.depth != 1 || this.triggerDepth <= 1) break;
                        for (Listener l : this.listeners()) {
                            l.STaXThreadNodeReceived(this, this.node);
                        }
                        continue block10;
                    }
                    case 2: {
                        if (this.depth == this.triggerDepth) {
                            for (Listener l : this.listeners()) {
                                l.STaXThreadNodeReceived(this, this.node);
                            }
                        } else {
                            this.node = this.node.getParentNode();
                        }
                        --this.depth;
                        break;
                    }
                    case 4: {
                        this.node.appendChild(this.document.createTextNode(this.xmlStreamReader.getText()));
                        break;
                    }
                }
            }
            for (Listener l : this.listeners()) {
                l.STaXThreadClosed(this);
            }
        }
        catch (Exception ex) {
            for (Listener l : this.listeners()) {
                l.STaXThreadError(this, ex);
            }
        }
        finally {
            this.running = false;
        }
    }

    public void start() {
        this.thread.start();
    }

    public void close() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public static interface Listener {
        public void STaXThreadClosed(STaXThread var1);

        public void STaXThreadError(STaXThread var1, Exception var2);

        public void STaXThreadNodeReceived(STaXThread var1, Node var2);
    }
}

