/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.thread;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import uk.org.retep.util.thread.ExecutorFactory;

public abstract class AbstractExecutorFactory<T>
extends ExecutorFactory {
    private final Map<T, ExecutorService> executors = new HashMap<T, ExecutorService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ExecutorService getExecutorService(T key) {
        ExecutorService executor;
        this.readLock().lock();
        try {
            executor = this.executors.get(key);
            if (executor != null) {
                ExecutorService executorService = executor;
                return executorService;
            }
        }
        finally {
            this.readLock().unlock();
        }
        this.writeLock().lock();
        try {
            executor = this.executors.get(key);
            if (executor != null) {
                ExecutorService executorService = executor;
                return executorService;
            }
            ExecutorService service = this.createExecutorService();
            this.executors.put(key, service);
            ExecutorService executorService = service;
            return executorService;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    protected abstract ExecutorService createExecutorService();
}

