/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.string;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import uk.org.retep.util.string.ParserUtils;

public class Tokenizer {
    public static final String DELIMITERS = " \t\n\r\f";
    private String string;
    private String delimiters;
    private boolean returnDelimiters;
    private List<Integer> tokens = new ArrayList<Integer>();
    private List<Integer> positions = new ArrayList<Integer>();
    private int pos;

    public Tokenizer(String aString) {
        this(aString, DELIMITERS, false);
    }

    public Tokenizer(String aString, String aDelimiter) {
        this(aString, aDelimiter, false);
    }

    public Tokenizer(String aString, boolean retDelims) {
        this(aString, DELIMITERS, retDelims);
    }

    public Tokenizer(String aString, String aDelimiter, boolean retDelims) {
        this.tokenize(aString, aDelimiter, retDelims);
    }

    public String getString() {
        return this.string;
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public boolean isReturnDelimiters() {
        return this.returnDelimiters;
    }

    public int countTokens() {
        return this.tokens.size();
    }

    public void tokenize(String aString) {
        this.tokenize(aString, this.getDelimiters(), this.isReturnDelimiters());
    }

    public void tokenize(String aString, String aDelimiter) {
        this.tokenize(aString, aDelimiter, this.isReturnDelimiters());
    }

    public void tokenize(String aString, String aDelimiter, boolean retDelims) {
        this.string = aString;
        this.delimiters = aDelimiter;
        this.returnDelimiters = retDelims;
        this.reset();
        this.tokens.clear();
        this.positions.clear();
        int s = 0;
        int p = 0;
        while (p > -1) {
            this.positions.add(s);
            if (s + 1 < this.string.length() && this.delimiters.indexOf(this.string.substring(s, s + 1)) == -1) {
                this.tokens.add(this.positions.size() - 1);
            }
            if ((p = ParserUtils.scanToken(this.string, this.delimiters, s)) <= -1) continue;
            if (p > s) {
                this.positions.add(p);
            }
            if (this.returnDelimiters) {
                this.tokens.add(this.positions.size() - 1);
            }
            s = p + 1;
        }
    }

    public void reset() {
        this.pos = 0;
    }

    public boolean hasMoreTokens() {
        return this.pos < this.tokens.size();
    }

    public String nextToken() {
        int sz = this.tokens.size();
        if (this.pos == sz) {
            throw new NoSuchElementException("no more tokens");
        }
        int p = this.tokens.get(this.pos++);
        String token = null;
        token = p + 1 == this.positions.size() ? this.string.substring(this.positions.get(p)) : this.string.substring(this.positions.get(p), this.positions.get(p + 1));
        return token;
    }

    public Iterator<String> iterator() {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return Tokenizer.this.hasMoreTokens();
            }

            @Override
            public String next() {
                return Tokenizer.this.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Method remove() not supported");
            }
        };
    }

    public Enumeration<String> enumerator() {
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return Tokenizer.this.hasMoreTokens();
            }

            @Override
            public String nextElement() {
                return Tokenizer.this.nextToken();
            }
        };
    }
}

