/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.string;

import java.util.Arrays;
import uk.org.retep.util.string.StringUtils;

public class Sentence {
    private String original;
    private Integer[] mappings;
    private String normalized;
    private String[] splitted;

    public Sentence(String original) {
        this(original, null, null);
    }

    public Sentence(String original, Integer[] mappings, String normalized) {
        this.setOriginal(original);
        this.setMappings(mappings);
        this.setNormalized(normalized);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Sentence)) {
            return false;
        }
        Sentence compared = (Sentence)obj;
        return this.original.equals(compared.original) && Arrays.equals((Object[])this.mappings, (Object[])compared.mappings) && this.normalized.equals(compared.normalized);
    }

    public int length() {
        return this.splitted.length;
    }

    public String[] normalized() {
        return this.splitted;
    }

    public String getWord(int index) {
        return this.splitted[index];
    }

    public String getWordUppercase(int index) {
        String word = this.getWord(index);
        return word == null ? null : word.toUpperCase();
    }

    public String normalized(int index) {
        return this.splitted[index];
    }

    public String original(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(beginIndex);
        }
        while (beginIndex >= 0 && this.mappings[beginIndex] == null) {
            --beginIndex;
        }
        int n = this.mappings.length;
        while (endIndex < n && this.mappings[endIndex] == null) {
            ++endIndex;
        }
        if (endIndex >= n) {
            endIndex = n - 1;
        }
        return StringUtils.removeNonAlphaNumeric(this.original.substring(this.mappings[beginIndex], this.mappings[endIndex] + 1));
    }

    public String toString() {
        return "[" + this.original + "]" + Arrays.toString((Object[])this.mappings) + "[" + this.normalized + "]";
    }

    public String trimOriginal() {
        return this.original.trim();
    }

    public Integer[] getMappings() {
        return this.mappings;
    }

    public void setMappings(Integer[] mappings) {
        this.mappings = mappings;
    }

    public String getNormalised() {
        return this.normalized;
    }

    public void setNormalized(String normalized) {
        this.normalized = normalized;
        if (normalized != null) {
            this.splitted = normalized.trim().split(" ");
        }
    }

    public String getOriginal() {
        return this.original;
    }

    public void setOriginal(String original) {
        this.original = original;
    }
}

