/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.pool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import uk.org.retep.util.pool.IdentityPoolEntryFactory;

public class IdentityPool<I, T> {
    private final Lock lock = new ReentrantLock();
    private final Mode mode;
    private IdentityPoolEntryFactory<I, T> factory;
    private Map<I, Entry<I, T>> entries = new HashMap<I, Entry<I, T>>();
    private boolean initialiseRequired;

    public IdentityPool(IdentityPoolEntryFactory<I, T> factory, Mode mode) {
        this(mode);
        this.factory = factory;
    }

    protected IdentityPool(Mode mode) {
        this.mode = mode;
        this.initialiseRequired = true;
    }

    protected final void setFactory(IdentityPoolEntryFactory<I, T> factory) {
        if (this.factory != null) {
            throw new IllegalStateException("Cannot set the factory once already set");
        }
        this.factory = factory;
    }

    protected final Lock lock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialise() {
        this.lock.lock();
        try {
            if (this.initialiseRequired) {
                this.factory.initialise(new IdentityPoolEntryFactory.IdentityPoolInitialiser<I, T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void setEntry(I identity, T value) {
                        IdentityPool.this.lock.lock();
                        try {
                            if (!IdentityPool.this.entries.containsKey(identity)) {
                                Entry e = new Entry(identity);
                                e.setValue(value);
                                IdentityPool.this.entries.put(identity, e);
                            }
                        }
                        finally {
                            IdentityPool.this.lock.unlock();
                        }
                    }

                    @Override
                    public IdentityPool<I, T> getContainingPool() {
                        return IdentityPool.this;
                    }
                });
                this.initialiseRequired = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T aquire(I identity) {
        this.lock.lock();
        try {
            Entry<I, T> entry;
            if (this.initialiseRequired) {
                this.initialise();
            }
            if ((entry = this.entries.get(identity)) == null) {
                entry = new Entry(identity);
                this.entries.put(identity, entry);
                entry.refreshRequired();
                this.factory.refresh(entry);
                T value = entry.aquire();
                if (value == null) {
                    this.remove(identity);
                }
                T t = value;
                return t;
            }
            if (entry.canRefresh() && this.mode.isLazyRefresh()) {
                this.factory.refresh(entry);
                T t = entry.aquire();
                return t;
            }
            T t = entry.aquire();
            return t;
        }
        catch (InterruptedException ie) {
            T t = null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(I identity) {
        this.lock.lock();
        try {
            Entry<I, T> entry = this.entries.get(identity);
            if (entry != null) {
                if (entry.released()) {
                    this.entries.remove(identity);
                    this.factory.removed(identity, entry.getValue());
                } else if (entry.canRefresh() && this.mode.isEagerRefresh()) {
                    this.factory.refresh(entry);
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(I identity) {
        this.lock.lock();
        try {
            Entry<I, T> e = this.entries.get(identity);
            if (e != null && e.removed()) {
                this.entries.remove(identity);
                this.factory.removed(identity, e.getValue());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void refresh(I identity) {
        if (this.mode.isEagerRefresh()) {
            this.refreshEagerly(identity);
        } else {
            this.refreshLazily(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean refreshEagerly(I identity) {
        this.lock.lock();
        try {
            Entry<I, T> entry = this.entries.get(identity);
            if (entry == null) {
                boolean bl = false;
                return bl;
            }
            entry.refreshRequired();
            this.factory.refresh(entry);
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException ie) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean refreshLazily(I identity) {
        this.lock.lock();
        try {
            Entry<I, T> entry = this.entries.get(identity);
            if (entry == null) {
                boolean bl = false;
                return bl;
            }
            entry.refreshRequired();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private final class Entry<I, T>
    implements IdentityPoolEntryFactory.IdentityPoolEntry<I, T> {
        private final I identity;
        private final Condition condition;
        private volatile T value;
        private volatile int inUseCount;
        private volatile boolean removable;
        private volatile boolean refresh;

        public Entry(I identity) {
            this.identity = identity;
            this.condition = IdentityPool.this.lock.newCondition();
        }

        @Override
        public I getIdentity() {
            return this.identity;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public void setValue(T value) {
            this.value = value;
        }

        @Override
        public void awaitForRefresh() throws InterruptedException {
            while (this.isRefreshRequired()) {
                this.condition.await();
            }
        }

        public void awaitUntilAvailable() throws InterruptedException {
            if (IdentityPool.this.mode.isBlocking()) {
                while (this.isRefreshRequired() || !this.isRemovable() && this.inUseCount > 0) {
                    this.condition.await();
                }
            }
        }

        public T aquire() throws InterruptedException {
            this.awaitUntilAvailable();
            if (this.isRemovable()) {
                return null;
            }
            ++this.inUseCount;
            return this.value;
        }

        public boolean released() {
            --this.inUseCount;
            this.condition.signalAll();
            return this.isRemovable();
        }

        public boolean isRemovable() {
            return this.removable && this.inUseCount < 1;
        }

        public boolean removed() {
            this.removable = true;
            return this.released();
        }

        @Override
        public boolean isRefreshRequired() {
            return this.refresh && !this.removable;
        }

        public boolean canRefresh() {
            return this.isRefreshRequired() && this.inUseCount < 1;
        }

        public void refreshRequired() {
            this.refresh = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void refreshed() {
            IdentityPool.this.lock.lock();
            try {
                if (this.refresh) {
                    this.refresh = false;
                    this.condition.signalAll();
                }
            }
            finally {
                IdentityPool.this.lock.unlock();
            }
        }

        @Override
        public final IdentityPool<I, T> getContainingPool() {
            return IdentityPool.this;
        }
    }

    public static enum Mode {
        CONCURRENT(false, false),
        CONCURRENT_LAZY_REFRESH(false, true),
        BLOCKING(true, false),
        BLOCKING_LAZY_REFRESH(true, true);

        private final boolean blocking;
        private final boolean lazyRefresh;

        private Mode(boolean blocking, boolean lazyRefresh) {
            this.blocking = blocking;
            this.lazyRefresh = lazyRefresh;
        }

        public boolean isBlocking() {
            return this.blocking;
        }

        public boolean isLazyRefresh() {
            return this.lazyRefresh;
        }

        public boolean isEagerRefresh() {
            return !this.lazyRefresh;
        }
    }
}

