/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class BinaryArrayDataSource
implements DataSource {
    private byte[] data;
    private ByteArrayOutputStream out;
    private ByteArrayInputStream in;
    private String type;
    private String name;

    public BinaryArrayDataSource(byte[] aArray) {
        this(aArray, "application/binary");
    }

    public BinaryArrayDataSource(byte[] aArray, String aContentType) {
        this(aArray, aContentType, "");
    }

    public BinaryArrayDataSource(byte[] aArray, String aContentType, String aName) {
        this.type = aContentType;
        this.name = aName;
        this.data = aArray;
    }

    public String getContentType() {
        return this.type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.out != null) {
            this.data = this.out.toByteArray();
        }
        this.in = new ByteArrayInputStream(this.data);
        return this.in;
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        this.out = new ByteArrayOutputStream();
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        finally {
            this.out = null;
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            finally {
                this.in = null;
            }
        }
    }
}

