/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.crypto.Cipher;
import uk.org.retep.util.io.Base64;

public class CryptoUtils {
    private CryptoUtils() {
    }

    public static String serializeToString(Serializable ... objs) throws IOException {
        return CryptoUtils.serializeToStringImpl(0, null, objs);
    }

    public static String serializeAndEncodeToString(Cipher cipher, Serializable ... objs) throws IOException {
        return CryptoUtils.serializeToStringImpl(0, cipher, objs);
    }

    public static String serializeAndCompressToString(Serializable ... objs) throws IOException {
        return CryptoUtils.serializeToStringImpl(2, null, objs);
    }

    public static String serializeEncodeAndCompressToString(Cipher cipher, Serializable ... objs) throws IOException {
        return CryptoUtils.serializeToStringImpl(2, cipher, objs);
    }

    private static String serializeToStringImpl(int options, Cipher cipher, Serializable ... objs) throws IOException {
        byte[] b = CryptoUtils.serializeToBytes(objs);
        if (cipher != null) {
            b = cipher.update(b);
        }
        return Base64.encodeBytes(b, options);
    }

    public static byte[] serializeToBytes(Serializable ... objs) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeInt(objs.length);
        for (Serializable obj : objs) {
            oos.writeObject(obj);
        }
        oos.flush();
        oos.close();
        baos.close();
        return baos.toByteArray();
    }

    public static Serializable[] serializeFromString(String s) throws IOException, ClassNotFoundException {
        return CryptoUtils.serializeFromBytes(Base64.decode(s));
    }

    public static Serializable[] serializeFromBytes(byte[] b) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ObjectInputStream ois = new ObjectInputStream(bais);
        int size = ois.readInt();
        Serializable[] ret = new Serializable[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (Serializable)Serializable.class.cast(ois.readObject());
        }
        return ret;
    }
}

