/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import uk.org.retep.util.javac.JavacUtils;

public abstract class AbstractServiceProcessor
extends AbstractProcessor {
    private Map<String, Set<String>> services = new HashMap<String, Set<String>>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        if (env.processingOver()) {
            return true;
        }
        JavacUtils utils = new JavacUtils(this.processingEnv, env);
        Set<? extends Element> annoElements = utils.env.getElementsAnnotatedWith(this.getAnnotationClass());
        for (Element element : annoElements) {
            this.processAnnotation(utils, element);
        }
        try {
            this.writeServices(utils);
        }
        catch (IOException ex) {
            utils.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
        }
        return !annoElements.isEmpty();
    }

    protected abstract Class<? extends Annotation> getAnnotationClass();

    protected abstract void processAnnotation(JavacUtils var1, Element var2);

    protected abstract String getServiceName(String var1);

    protected void registerService(JavacUtils utils, String fileName, String className) {
        String serviceName;
        String outputFileName = "META-INF/services/" + fileName;
        Set<String> s = this.services.get(outputFileName);
        if (s == null) {
            s = new HashSet<String>();
            this.readServices(utils, outputFileName, s);
            this.services.put(outputFileName, s);
        }
        if ((serviceName = this.getServiceName(fileName)) != null) {
            if (s.add(className)) {
                utils.messager.printMessage(Diagnostic.Kind.NOTE, "Registering " + serviceName + " " + className);
            } else {
                utils.messager.printMessage(Diagnostic.Kind.NOTE, serviceName + " " + className + " is already registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readServices(JavacUtils utils, String fileName, Set<String> set) {
        try {
            FileObject fo = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", fileName);
            File f = new File(fo.toUri().toString());
            if (!f.exists()) {
                return;
            }
            String serviceName = this.getServiceName(fileName);
            BufferedReader br = new BufferedReader(new FileReader(f));
            try {
                String line = br.readLine();
                while (line != null) {
                    if (!line.startsWith("#")) {
                        utils.messager.printMessage(Diagnostic.Kind.NOTE, "Found " + serviceName + " " + line);
                        set.add(line);
                    }
                    line = br.readLine();
                }
            }
            finally {
                br.close();
            }
        }
        catch (IOException ioe) {
            utils.messager.printMessage(Diagnostic.Kind.ERROR, ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeServices(JavacUtils utils) throws IOException {
        for (Map.Entry<String, Set<String>> s : this.services.entrySet()) {
            if (s.getValue().isEmpty()) continue;
            utils.messager.printMessage(Diagnostic.Kind.NOTE, "Generating " + s.getKey());
            FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", s.getKey(), new Element[0]);
            Writer w = fo.openWriter();
            try {
                for (String c : s.getValue()) {
                    w.write(c);
                    w.write(10);
                }
            }
            finally {
                w.close();
            }
        }
    }
}

