/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.thread;

public final class ThreadUtil {
    private ThreadUtil() {
    }

    public static StackTraceElement getCaller() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return stack != null && stack.length > 6 ? stack[5] : null;
    }

    public static Class<?> getCallerClass() throws ClassNotFoundException {
        Class<?> clazz = null;
        StackTraceElement caller = ThreadUtil.getCaller();
        if (caller != null) {
            clazz = Class.forName(caller.getClassName());
        }
        return clazz;
    }

    public static Class<?> getCallerClass(String prefix) throws ClassNotFoundException {
        String className = ThreadUtil.class.getName();
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (ste.getClassName().equals(className) || ste.getClassName().startsWith("uk.org.retep.kernel") || ste.getClassName().startsWith("java.") || ste.getClassName().startsWith("javax.") || ste.getClassName().startsWith("com.sun.") || ste.getClassName().startsWith("sun.")) continue;
            return Class.forName(ste.getClassName());
        }
        return null;
    }
}

