/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import uk.org.retep.logging.Log;
import uk.org.retep.util.io.AbstractFileVisitor;
import uk.org.retep.util.io.BufferedCharReader;
import uk.org.retep.util.io.FileVisitor;

public class FileUtils {
    public static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file != null && file.isDirectory() && file.canRead();
        }
    };
    public static final FileFilter FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file != null && file.isFile() && file.canRead();
        }
    };
    public static final FileFilter JAVA_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file != null && file.isFile() && file.canRead() && file.getName().endsWith(".java");
        }
    };
    public static final FileFilter JAR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file != null && file.isFile() && file.canRead() && file.getName().endsWith(".jar");
        }
    };

    public static URL[] toURL(File ... files) throws MalformedURLException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = files[i].toURI().toURL();
        }
        return urls;
    }

    public static URL[] toURLArray(Collection<File> files) throws MalformedURLException {
        List<URL> urls = FileUtils.toURL(files);
        return urls.toArray(new URL[urls.size()]);
    }

    public static List<URL> toURL(Collection<File> files) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            urls.add(file.toURI().toURL());
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] byArray = FileUtils.readBytes(fis);
            return byArray;
        }
        finally {
            fis.close();
        }
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copy(is, baos);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copyFile(File sourceFile, File destinationFile) throws IOException {
        FileOutputStream os = new FileOutputStream(destinationFile);
        try {
            int s = FileUtils.copyFile(sourceFile, os);
            destinationFile.setLastModified(sourceFile.lastModified());
            int n = s;
            return n;
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copyFile(File file, OutputStream os) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            int n = FileUtils.copy(is, os);
            return n;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copyFile(InputStream is, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            int n = FileUtils.copy(is, os);
            return n;
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static final int copy(InputStream is, OutputStream os) throws IOException {
        int c = 0;
        byte[] b = new byte[1024];
        int s = is.read(b);
        while (s > -1) {
            c += s;
            os.write(b, 0, s);
            s = is.read(b);
        }
        return c;
    }

    public static final StringBuilder read(File f) throws IOException {
        return FileUtils.read(f, new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StringBuilder read(File f, StringBuilder sb) throws IOException {
        FileReader fr = new FileReader(f);
        try {
            StringBuilder stringBuilder = FileUtils.readImpl(new BufferedReader(fr), sb);
            return stringBuilder;
        }
        finally {
            fr.close();
        }
    }

    public static final StringBuilder read(InputStream is) throws IOException {
        return FileUtils.read(is, new StringBuilder());
    }

    public static final StringBuilder read(Reader r) throws IOException {
        return FileUtils.read(r, new StringBuilder());
    }

    public static final StringBuilder read(InputStream is, StringBuilder sb) throws IOException {
        return FileUtils.read(new InputStreamReader(is), sb);
    }

    public static final StringBuilder read(Reader r, StringBuilder sb) throws IOException {
        if (r instanceof BufferedReader) {
            return FileUtils.readImpl((BufferedReader)BufferedReader.class.cast(r), sb);
        }
        return FileUtils.readImpl(new BufferedReader(r), sb);
    }

    private static final StringBuilder readImpl(BufferedReader r, StringBuilder sb) throws IOException {
        char[] b = new char[1024];
        int s = r.read(b);
        while (s > -1) {
            sb.append(b, 0, s);
            s = r.read(b);
        }
        return sb;
    }

    public static final List<String> readLines(File f) throws IOException {
        return FileUtils.readLines(f, new ArrayList<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<String> readLines(File f, List<String> list) throws IOException {
        FileReader fr = new FileReader(f);
        try {
            List<String> list2 = FileUtils.readLines(fr, list);
            return list2;
        }
        finally {
            fr.close();
        }
    }

    public static final List<String> readLines(InputStream is) throws IOException {
        return FileUtils.readLines(is, new ArrayList<String>());
    }

    public static final List<String> readLines(Reader r) throws IOException {
        return FileUtils.readLines(r, new ArrayList<String>());
    }

    public static final List<String> readLines(InputStream is, List<String> list) throws IOException {
        return FileUtils.readLines(new InputStreamReader(is), list);
    }

    public static final List<String> readLines(Reader r, List<String> list) throws IOException {
        return FileUtils.readLines(new BufferedCharReader(r), list);
    }

    public static final List<String> readLines(BufferedCharReader r) throws IOException {
        return FileUtils.readLines(r, new ArrayList<String>());
    }

    private static final List<String> readLines(BufferedCharReader r, List<String> list) throws IOException {
        r.fill();
        StringBuilder sb = new StringBuilder();
        while (r.getAvailable() > 0) {
            char c = r.getCurrent();
            if (c == '\n' || c == '\f') {
                list.add(sb.toString());
                sb.setLength(0);
            } else if (c >= ' ') {
                sb.append(c);
            }
            r.moveForward(1);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list;
    }

    public static List<File> findFiles(File directory, FileFilter filter, boolean recurse) {
        return FileUtils.findFiles(null, directory, filter, recurse);
    }

    public static List<File> findFiles(List<File> files, File directory, FileFilter filter, boolean recurse) {
        ArrayList<File> ret = files == null ? new ArrayList<File>() : files;
        for (File file : directory.listFiles(filter)) {
            ret.add(file);
        }
        if (recurse) {
            for (File dir : directory.listFiles(DIRECTORY_FILTER)) {
                FileUtils.findFiles(ret, dir, filter, true);
            }
        }
        return ret;
    }

    public static void assertFileInsideDirectory(File baseDirectory, File file) {
        String basePath = baseDirectory.getAbsolutePath();
        if (!file.getAbsolutePath().startsWith(basePath)) {
            throw new SecurityException("Not permitted to write outside the installation directory " + basePath);
        }
    }

    public static File mkdir(File dir, Log log) {
        if (dir.mkdir() && log != null) {
            log.info("Created %s", dir.getPath());
        }
        return dir;
    }

    public static File mkdirs(File dir, Log log) {
        if (dir.mkdirs() && log != null) {
            log.info("Created %s", dir.getPath());
        }
        return dir;
    }

    public static boolean visitFiles(FileVisitor visitor, Collection<File> files) throws IOException {
        return FileUtils.visitFiles(visitor, files, false);
    }

    public static boolean visitFiles(FileVisitor visitor, Collection<File> files, boolean allModified) throws IOException {
        boolean ret = false;
        if (allModified) {
            for (File file : files) {
                ret &= visitor.visit(file);
            }
        } else {
            for (File file : files) {
                ret |= visitor.visit(file);
            }
        }
        return ret;
    }

    public static List<File> scanFiles(FileFilter fileFilter, String ... sources) {
        return FileUtils.scanFiles(fileFilter, Arrays.asList(sources));
    }

    public static List<File> scanFiles(FileFilter fileFilter, List<String> sources) {
        ArrayList<File> files = new ArrayList<File>();
        for (String dir : sources) {
            files.add(new File(dir));
        }
        return FileUtils.findFiles(fileFilter, files);
    }

    public static List<File> findFiles(FileFilter fileFilter, List<File> sources) {
        ArrayList<File> files = new ArrayList<File>();
        for (File dir : sources) {
            if (!dir.isDirectory() || !dir.canRead()) continue;
            FileUtils.findFiles(files, dir, fileFilter, true);
        }
        return files;
    }

    public static FileVisitor getSetExecutableVisitor(boolean state) {
        return FileUtils.getSetExecutableVisitor(null, state, true);
    }

    public static FileVisitor getSetExecutableVisitor(boolean state, boolean ownerOnly) {
        return FileUtils.getSetExecutableVisitor(null, state, ownerOnly);
    }

    public static FileVisitor getSetExecutableVisitor(Log log, boolean state) {
        return FileUtils.getSetExecutableVisitor(log, state, true);
    }

    public static FileVisitor getSetExecutableVisitor(Log log, final boolean state, final boolean ownerOnly) {
        String msg = state ? "Set executable on %s" : "Cleared executable on %s";
        return new AbstractFileVisitor(log, msg){

            @Override
            protected boolean execute(File file) throws IOException {
                return file.setExecutable(state, ownerOnly);
            }
        };
    }

    public static FileVisitor getSetReadOnlyVisitor(boolean state) {
        return FileUtils.getSetReadOnlyVisitor(null, state, true);
    }

    public static FileVisitor getSetReadOnlyVisitor(boolean state, boolean ownerOnly) {
        return FileUtils.getSetReadOnlyVisitor(null, state, ownerOnly);
    }

    public static FileVisitor getSetReadOnlyVisitor(Log log, boolean state) {
        return FileUtils.getSetReadOnlyVisitor(log, state, true);
    }

    public static FileVisitor getSetReadOnlyVisitor(Log log, final boolean state, final boolean ownerOnly) {
        String msg = state ? "Set readable on %s" : "Cleared readable on %s";
        return new AbstractFileVisitor(log, msg){

            @Override
            protected boolean execute(File file) throws IOException {
                return file.setReadable(state, ownerOnly);
            }
        };
    }

    public static FileVisitor getSetWritableVisitor(boolean state) {
        return FileUtils.getSetWritableVisitor(null, state, true);
    }

    public static FileVisitor getSetWritableVisitor(boolean state, boolean ownerOnly) {
        return FileUtils.getSetWritableVisitor(null, state, ownerOnly);
    }

    public static FileVisitor getSetWritableVisitor(Log log, boolean state) {
        return FileUtils.getSetWritableVisitor(log, state, true);
    }

    public static FileVisitor getSetWritableVisitor(Log log, final boolean state, final boolean ownerOnly) {
        String msg = state ? "Set writable on %s" : "Cleared writable on %s";
        return new AbstractFileVisitor(log, msg){

            @Override
            protected boolean execute(File file) throws IOException {
                return file.setWritable(state, ownerOnly);
            }
        };
    }

    public static FileVisitor getCopyFileVisitor(File destinationDirectory) {
        return FileUtils.getCopyFileVisitor((Log)null, destinationDirectory, true);
    }

    public static FileVisitor getCopyFileVisitor(File destinationDirectory, boolean overwrite) {
        return FileUtils.getCopyFileVisitor((Log)null, destinationDirectory, overwrite);
    }

    public static FileVisitor getCopyFileVisitor(Log log, File destinationDirectory) {
        return FileUtils.getCopyFileVisitor(log, destinationDirectory, true);
    }

    public static FileVisitor getCopyFileVisitor(Log log, String message, File destinationDirectory) {
        return FileUtils.getCopyFileVisitor(log, message, destinationDirectory, true);
    }

    public static FileVisitor getCopyFileVisitor(Log log, File destinationDirectory, boolean overwrite) {
        return FileUtils.getCopyFileVisitor(log, "Copied %s to " + destinationDirectory.getPath(), destinationDirectory, overwrite);
    }

    public static FileVisitor getCopyFileVisitor(Log log, String message, final File destinationDirectory, final boolean overwrite) {
        return new AbstractFileVisitor(log, message){

            @Override
            protected boolean execute(File file) throws IOException {
                boolean copy;
                File destinationFile = new File(destinationDirectory, file.getName());
                boolean bl = copy = !destinationFile.exists() || overwrite;
                if (!copy) {
                    boolean bl2 = copy = file.lastModified() > destinationFile.lastModified();
                }
                if (copy) {
                    FileUtils.copyFile(file, destinationFile);
                    return true;
                }
                return false;
            }
        };
    }
}

