/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.queue;

import java.util.Collection;
import java.util.LinkedList;

public class BoundedLinkedList<E>
extends LinkedList<E> {
    static final long serialVersionUID = -2079073799559500572L;
    static final int MAX_ELEMENTS = 100000;
    private final int maxElements;

    public BoundedLinkedList() {
        this(100000);
    }

    public BoundedLinkedList(Collection<? extends E> elements) {
        this(100000, elements);
    }

    public BoundedLinkedList(int maxElements) {
        this.maxElements = maxElements;
    }

    public BoundedLinkedList(int maxElements, Collection<? extends E> elements) {
        super(elements);
        this.maxElements = maxElements;
    }

    @Override
    public boolean add(E x) {
        if (this.size() >= this.maxElements) {
            throw new IllegalStateException("full");
        }
        return super.add(x);
    }

    @Override
    public boolean offer(E e) {
        if (this.size() >= this.maxElements) {
            return false;
        }
        return super.offer(e);
    }

    @Override
    public boolean offerFirst(E e) {
        if (this.size() >= this.maxElements) {
            return false;
        }
        return super.offerFirst(e);
    }

    @Override
    public boolean offerLast(E e) {
        if (this.size() >= this.maxElements) {
            return false;
        }
        return super.offerLast(e);
    }

    public int remainingCapacity() {
        return this.maxElements - this.size();
    }
}

