/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import uk.org.retep.util.collections.ConcurrencySupport;

public class ConcurrentPropertySupport
extends ConcurrencySupport {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected final PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(name, listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(name, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsProperty(String name) {
        this.readLock().lock();
        try {
            boolean bl = this.properties.containsKey(name);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeProperty(String name) {
        this.writeLock().lock();
        try {
            Object value = this.properties.remove(name);
            this.propertyChangeSupport.firePropertyChange(name, value, null);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearProperties() {
        this.writeLock().lock();
        try {
            for (String key : this.properties.keySet()) {
                this.propertyChangeSupport.firePropertyChange(key, this.properties.get(key), null);
            }
            this.properties.clear();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<String> propertyNames() {
        this.readLock().lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.properties.keySet());
            return hashSet;
        }
        finally {
            this.readLock().unlock();
        }
    }

    public final boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public final boolean getBooleanProperty(String name, boolean defaultValue) {
        Object value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(String.valueOf(value));
    }

    public final void setBooleanProperty(String name, boolean value) {
        this.setProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getProperty(String name) {
        this.readLock().lock();
        try {
            Object object = this.properties.get(name);
            return object;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object setProperty(String name, Object value) {
        this.writeLock().lock();
        try {
            Object oldValue = this.properties.put(name, value);
            this.propertyChangeSupport.firePropertyChange(name, oldValue, value);
            Object object = oldValue;
            return object;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public final String getStringProperty(String name) {
        return this.getStringProperty(name, null);
    }

    public final String getStringProperty(String name, String defaultValue) {
        Object value = this.getProperty(name);
        return value == null ? defaultValue : String.valueOf(value);
    }

    public final void setStringProperty(String name, String value) {
        this.setProperty(name, value);
    }

    public final int getIntProperty(String name) {
        return this.getIntProperty(name, 0);
    }

    public final int getIntProperty(String name, int defaultValue) {
        Object value = this.getProperty(name);
        return value == null ? defaultValue : (Integer)value;
    }

    public final void setIntProperty(String name, int value) {
        this.setProperty(name, value);
    }

    public final double getDoubleProperty(String name) {
        return this.getDoubleProperty(name, 0.0);
    }

    public final double getDoubleProperty(String name, double defaultValue) {
        Object value = this.getProperty(name);
        return value == null ? defaultValue : (Double)value;
    }

    public final void setDoubleProperty(String name, double value) {
        this.setProperty(name, value);
    }
}

