/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import uk.org.retep.util.http.HttpResponseCode;
import uk.org.retep.util.mime.ContentType;
import uk.org.retep.util.string.StringUtils;

public final class RequestUtils {
    private RequestUtils() {
    }

    public static final void sendResponse(HttpExchange exchange, int responseCode) throws IOException {
        HttpResponseCode code = HttpResponseCode.valueOf(responseCode);
        RequestUtils.sendResponse(exchange, code);
    }

    public static final void sendResponse(HttpExchange exchange, HttpResponseCode responseCode) throws IOException {
        RequestUtils.sendResponse(exchange, responseCode.getCode(), responseCode.getDescription(), new Object[0]);
    }

    public static final void sendResponse(HttpExchange exchange, HttpResponseCode responseCode, String message, Object ... args) throws IOException {
        RequestUtils.sendResponse(exchange, responseCode.getCode(), message, args);
    }

    public static final void sendResponse(HttpExchange exchange, int responseCode, String message, Object ... args) throws IOException {
        String msg = message == null ? "" : StringUtils.format(message, args);
        exchange.sendResponseHeaders(responseCode, msg.length());
        OutputStream os = exchange.getResponseBody();
        os.write(msg.getBytes());
        os.close();
    }

    public static final void addHeader(HttpExchange exchange, String name, String value) {
        exchange.getResponseHeaders().add(name, value);
    }

    public static final void setHeader(HttpExchange exchange, String name, String value) {
        exchange.getResponseHeaders().set(name, value);
    }

    public static final void setContentType(HttpExchange exchange, String contentType) {
        RequestUtils.setHeader(exchange, "content-type", contentType);
    }

    public static final void setContentType(HttpExchange exchange, ContentType contentType) {
        RequestUtils.setHeader(exchange, "content-type", contentType.getMimeType());
    }

    public static final void redirect(HttpExchange exchange, String path) throws IOException {
        RequestUtils.redirect(exchange, HttpResponseCode.REDIRECT_FOUND, path);
    }

    public static final void redirect(HttpExchange exchange, URI uri, String path) throws IOException {
        try {
            URI newUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), exchange.getHttpContext().getPath() + path, uri.getQuery(), uri.getFragment());
            RequestUtils.redirect(exchange, HttpResponseCode.REDIRECT_FOUND, newUri.toString());
        }
        catch (URISyntaxException use) {
            throw new IOException(use);
        }
    }

    public static final void redirectPermanently(HttpExchange exchange, String path) throws IOException {
        RequestUtils.redirect(exchange, HttpResponseCode.REDIRECT_MOVED_PERMANENTLY, path);
    }

    public static final void redirectPermanently(HttpExchange exchange, URI uri, String path) throws IOException {
        try {
            URI newUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), exchange.getHttpContext().getPath() + path, uri.getQuery(), uri.getFragment());
            RequestUtils.redirect(exchange, HttpResponseCode.REDIRECT_MOVED_PERMANENTLY, newUri.toString());
        }
        catch (URISyntaxException use) {
            throw new IOException(use);
        }
    }

    private static final void redirect(HttpExchange exchange, HttpResponseCode code, String path) throws IOException {
        RequestUtils.addHeader(exchange, "Location", path);
        RequestUtils.sendResponse(exchange, code);
    }

    public static final PrintWriter getResponseWriter(HttpExchange exchange) {
        return new PrintWriter(exchange.getResponseBody());
    }

    public static final void sendResponseHeaders(HttpExchange exchange) throws IOException {
        RequestUtils.sendResponseHeaders(exchange, HttpResponseCode.SUCCESS_OK, null);
    }

    public static final void sendResponseHeaders(HttpExchange exchange, HttpResponseCode code) throws IOException {
        RequestUtils.sendResponseHeaders(exchange, code, null);
    }

    public static final void sendResponseHeaders(HttpExchange exchange, ContentType contentType) throws IOException {
        RequestUtils.sendResponseHeaders(exchange, HttpResponseCode.SUCCESS_OK, contentType);
    }

    public static final void sendResponseHeaders(HttpExchange exchange, HttpResponseCode code, ContentType contentType) throws IOException {
        if (contentType != null) {
            RequestUtils.setContentType(exchange, contentType);
        }
        exchange.sendResponseHeaders(code.getCode(), 0L);
    }
}

