/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.mojo.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import uk.org.retep.util.string.StringUtils;

public final class MavenUtils {
    private MavenUtils() {
    }

    public static List<String> getArgumentList(List<String> dest, List<String> list) {
        ArrayList<String> args;
        ArrayList<String> arrayList = args = dest == null ? new ArrayList<String>() : dest;
        if (list != null) {
            args.addAll(list);
        }
        return args;
    }

    public static List<String> getArgumentList(List<String> dest, Map<String, String> map) {
        ArrayList<String> args;
        ArrayList<String> arrayList = args = dest == null ? new ArrayList<String>() : dest;
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                args.add("-" + entry.getKey());
                args.add(entry.getValue());
            }
        }
        return args;
    }

    public static List<String> getList(List<String> list) {
        return list == null ? new ArrayList() : list;
    }

    public static String getClassPath(MavenProject mavenProject, ArtifactFactory artifactFactory, ArtifactResolver resolver, List remoteRepositories, ArtifactRepository localRepository, File outputDirectory) throws MojoFailureException {
        return MavenUtils.getClassPath(mavenProject, artifactFactory, resolver, remoteRepositories, localRepository, outputDirectory, false);
    }

    public static String getClassPath(MavenProject mavenProject, ArtifactFactory artifactFactory, ArtifactResolver resolver, List remoteRepositories, ArtifactRepository localRepository, File outputDirectory, boolean includeTestClassPath) throws MojoFailureException {
        StringBuilder cp = new StringBuilder();
        for (Object obj : mavenProject.getDependencies()) {
            Dependency dep = (Dependency)obj;
            Artifact artifact = artifactFactory.createArtifactWithClassifier(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), dep.getClassifier());
            String scope = dep.getScope();
            artifact.setScope(scope);
            if (!"system".equals(scope)) {
                try {
                    resolver.resolve(artifact, remoteRepositories, localRepository);
                }
                catch (ArtifactResolutionException ex) {
                    throw new MojoFailureException("Failed to resolve " + artifact);
                }
                catch (ArtifactNotFoundException ex) {
                    throw new MojoFailureException("Failed to find " + artifact);
                }
            }
            if (!includeTestClassPath && "test".equals(scope)) continue;
            cp.append(artifact.getFile()).append(':');
        }
        if (outputDirectory != null) {
            cp.append(outputDirectory.getPath());
        } else if (cp.length() > 0) {
            cp.setLength(cp.length() - 1);
        }
        return cp.toString();
    }

    public static List<Artifact> getProjectArtifacts(MavenProject mavenProject, ArtifactFactory artifactFactory, ArtifactResolver resolver, List remoteRepositories, ArtifactRepository localRepository, String scope) throws MojoFailureException {
        return MavenUtils.getProjectArtifacts(mavenProject, artifactFactory, resolver, null, remoteRepositories, localRepository, scope, false);
    }

    public static List<Artifact> getProjectArtifacts(MavenProject mavenProject, ArtifactFactory artifactFactory, ArtifactResolver resolver, ArtifactMetadataSource metadataSource, List remoteRepositories, ArtifactRepository localRepository, String scope, boolean includeDependencies) throws MojoFailureException {
        return MavenUtils.getProjectArtifacts(new ArrayList<Artifact>(), mavenProject, artifactFactory, resolver, metadataSource, remoteRepositories, localRepository, scope, includeDependencies);
    }

    private static List<Artifact> getProjectArtifacts(List<Artifact> artifacts, MavenProject mavenProject, ArtifactFactory artifactFactory, ArtifactResolver resolver, ArtifactMetadataSource metadataSource, List remoteRepositories, ArtifactRepository localRepository, String scope, boolean includeDependencies) throws MojoFailureException {
        for (Object obj : mavenProject.getDependencies()) {
            Dependency dep = (Dependency)obj;
            if (!MavenUtils.isSameScope(scope, dep.getScope())) continue;
            Artifact artifact = MavenUtils.getArtifact(artifactFactory, resolver, remoteRepositories, localRepository, dep);
            artifacts.add(artifact);
        }
        if (includeDependencies) {
            HashSet<Artifact> set = new HashSet<Artifact>(artifacts);
            artifacts.clear();
            artifacts.addAll(MavenUtils.resolveTransitively(set, mavenProject, resolver, metadataSource, remoteRepositories, localRepository));
        }
        return artifacts;
    }

    public static Collection<Artifact> resolveTransitively(Set<Artifact> artifacts, MavenProject mavenProject, ArtifactResolver resolver, ArtifactMetadataSource metadataSource, List remoteRepositories, ArtifactRepository localRepository) throws MojoFailureException {
        try {
            ArtifactResolutionResult result = resolver.resolveTransitively(artifacts, mavenProject.getArtifact(), Collections.EMPTY_MAP, localRepository, remoteRepositories, metadataSource, null, Collections.EMPTY_LIST);
            return result.getArtifacts();
        }
        catch (ArtifactResolutionException ex) {
            throw new MojoFailureException(ex.getMessage());
        }
        catch (ArtifactNotFoundException ex) {
            throw new MojoFailureException(ex.getMessage());
        }
    }

    public static Artifact getArtifact(ArtifactFactory artifactFactory, ArtifactResolver resolver, List remoteRepositories, ArtifactRepository localRepository, Dependency dependency) throws MojoFailureException {
        return MavenUtils.getArtifact(artifactFactory, resolver, remoteRepositories, localRepository, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier(), dependency.getScope());
    }

    public static Artifact getArtifact(ArtifactFactory artifactFactory, ArtifactResolver resolver, List remoteRepositories, ArtifactRepository localRepository, String groupId, String artifactId, String version, String type, String classifier, String scope) throws MojoFailureException {
        Artifact artifact = artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        artifact.setScope(scope);
        try {
            resolver.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (ArtifactResolutionException ex) {
            throw new MojoFailureException("Failed to resolve " + artifact);
        }
        catch (ArtifactNotFoundException ex) {
            throw new MojoFailureException("Failed to find " + artifact);
        }
        return artifact;
    }

    public static boolean isSameScope(String scope1, String scope2) {
        if (scope1 == null && scope2 == null) {
            return true;
        }
        return scope1 != null && scope1.equals(scope2);
    }

    public static String addToolsJar(String classPath) {
        File javaHome = new File(System.getProperty("java.home"));
        File toolsJar = new File(javaHome, "../lib/tools.jar");
        if (!toolsJar.exists()) {
            toolsJar = new File(javaHome, "lib/tools.jar");
        }
        if (toolsJar.exists()) {
            if (StringUtils.isStringEmpty((String)classPath)) {
                return toolsJar.getPath();
            }
            return classPath + File.pathSeparator + toolsJar.getPath();
        }
        return classPath;
    }
}

