/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.mojo.annotation;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import uk.org.retep.mojo.util.AbstractMojo;
import uk.org.retep.mojo.util.MavenUtils;
import uk.org.retep.util.io.FileFilterSet;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.io.LogicFileFilter;
import uk.org.retep.util.io.PackageFileFilter;
import uk.org.retep.util.string.StringUtils;

public abstract class AbstractCompilerMojo
extends AbstractMojo {
    protected Map<String, String> configuration;
    protected List<String> compilerArguments;
    protected List<String> sources;
    protected List<String> includes;
    protected List<String> excludes;
    protected boolean toolsJar;
    protected boolean test;

    protected boolean isToolsJar() {
        return this.toolsJar;
    }

    protected boolean isTest() {
        return this.test;
    }

    protected List<String> getCompilerArguments() {
        List<String> args = MavenUtils.getArgumentList(null, this.compilerArguments);
        MavenUtils.getArgumentList(args, this.configuration);
        StringUtils.stripCommentsBlankLines(args);
        return args;
    }

    protected List<String> getSources() {
        List<String> list = MavenUtils.getList(this.sources);
        if (list.isEmpty()) {
            if (this.isTest()) {
                list.add(this.mavenProject.getBuild().getTestSourceDirectory());
            } else {
                list.add(this.mavenProject.getBuild().getSourceDirectory());
            }
        }
        list.add(this.mavenProject.getBuild().getOutputDirectory());
        if (this.isTest()) {
            list.add(this.mavenProject.getBuild().getTestOutputDirectory());
        }
        return list;
    }

    protected List<String> getIncludes() {
        return MavenUtils.getList(this.includes);
    }

    protected List<String> getExcludes() {
        return MavenUtils.getList(this.excludes);
    }

    @Override
    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    protected final FileFilter getFileFilter(List<String> sources, List<String> includes, List<String> excludes) {
        FileFilterSet filters = new FileFilterSet();
        for (String dir : sources) {
            File dirFile = new File(dir);
            if (includes != null && !includes.isEmpty()) {
                for (String glob : includes) {
                    filters.add((Object)new PackageFileFilter.Include(dirFile, new String[]{glob}));
                }
            }
            if (excludes == null || excludes.isEmpty()) continue;
            for (String glob : excludes) {
                filters.add((Object)new PackageFileFilter.Exclude(dirFile, new String[]{glob}));
            }
        }
        if (filters.isEmpty()) {
            return FileUtils.JAVA_FILTER;
        }
        return new LogicFileFilter.And(new FileFilter[]{FileUtils.JAVA_FILTER, filters});
    }

    protected void runLocalProcessors(JavaCompiler compiler, StandardJavaFileManager fileManager, List<String> options, List<File> files, File outputDirectory, String classPath) throws MojoFailureException {
        File processorFile = new File(outputDirectory, "META-INF/services/javax.annotation.processing.Processor");
        if (processorFile.exists() && processorFile.isFile() && processorFile.canRead()) {
            ArrayList processors = new ArrayList();
            try {
                FileUtils.readLines((File)processorFile, processors);
            }
            catch (IOException ex) {
                throw new MojoFailureException("Failed to read annotation processors");
            }
            StringUtils.stripCommentsBlankLines(processors);
            if (!processors.isEmpty()) {
                ArrayList<String> opts = new ArrayList<String>(options);
                opts.add("-processor");
                opts.add(StringUtils.join((char)',', processors));
                opts.add("-processorpath");
                opts.add(classPath);
                opts.remove("-proc:none");
                opts.remove("-proc:only");
                opts.add("-proc:only");
                if (this.verbose) {
                    this.getLog().info((CharSequence)("      ClassPath: " + classPath));
                    this.getLog().info((CharSequence)("OutputDirectory: " + outputDirectory));
                    this.getLog().info((CharSequence)("        Options: " + StringUtils.join((char)' ', opts)));
                }
                this.getLog().info((CharSequence)("Running local annotation processors over " + files.size() + " source files"));
                this.javac(compiler, fileManager, opts, files);
            }
        }
    }

    protected final void javac(List<String> options, List<File> files, File outputDirectory, String classPath) throws MojoFailureException {
        this.javac(options, files, outputDirectory, classPath, false);
    }

    protected final void javac(List<String> options, List<File> files, File outputDirectory, String classPath, boolean preprocessAnnotations) throws MojoFailureException {
        options.add("-classpath");
        options.add(this.isToolsJar() ? MavenUtils.addToolsJar(classPath) : classPath);
        options.add("-d");
        options.add(outputDirectory.getPath());
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        if (preprocessAnnotations) {
            this.runLocalProcessors(compiler, fileManager, options, files, outputDirectory, classPath);
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)("      ClassPath: " + classPath));
            this.getLog().info((CharSequence)("OutputDirectory: " + outputDirectory));
            this.getLog().info((CharSequence)("        Options: " + StringUtils.join((char)' ', options)));
        }
        this.getLog().info((CharSequence)("Compiling " + files.size() + " source files to " + outputDirectory));
        this.javac(compiler, fileManager, options, files);
        try {
            fileManager.close();
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)ex.toString(), (Throwable)ex);
            throw new MojoFailureException("Failed to write classes");
        }
    }

    protected final void javac(JavaCompiler compiler, StandardJavaFileManager fileManager, List<String> options, List<File> files) throws MojoFailureException {
        Iterable<? extends JavaFileObject> compilationUnit = fileManager.getJavaFileObjectsFromFiles(files);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, options, null, compilationUnit);
        if (!task.call().booleanValue()) {
            throw new MojoFailureException("CompilationTask failure");
        }
    }

    protected final void javac(boolean preprocessAnnotations) throws MojoExecutionException, MojoFailureException {
        String classPath;
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (StringUtils.isStringEmpty((String)(classPath = MavenUtils.getClassPath(this.mavenProject, this.artifactFactory, this.resolver, this.remoteRepositories, this.localRepository, this.outputDirectory, this.isTest())))) {
            throw new MojoFailureException("No classpath is defined");
        }
        if (this.isTest()) {
            classPath = classPath + ":" + this.srcOutputDirectory;
        }
        List<String> sourceDirs = this.getSources();
        FileFilter fileFilter = this.getFileFilter(sourceDirs, this.getIncludes(), this.getExcludes());
        List files = FileUtils.scanFiles((FileFilter)fileFilter, sourceDirs);
        List<String> options = this.getCompilerArguments();
        this.javac(options, files, this.outputDirectory, classPath, preprocessAnnotations);
    }
}

