/*
 * Decompiled with CFR 0.152.
 */
package uk.num.validators;

import java.util.regex.Pattern;
import uk.num.validators.NumDomainValidator;
import uk.num.validators.ValidationResult;

public class NumEmailAddressValidator {
    public static final Pattern NUM_EMAIL_REGEX = Pattern.compile("^(?!\\s)[^@\f\t\r\b\n]+?(?<!\\s)@(([^.\\s\f\t\r\b\n]+?\\.)*?([^!\"#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~\\s\f\t\r\b\n]+?\\.)([^!\"#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~\\s\f\t\r\b\n]+?))\\.??$");
    public static final int MAX_LOCAL_PART_LENGTH = 64;

    private NumEmailAddressValidator() {
    }

    public static ValidationResult validateAcceptingNullAsValid(String emailAddress) {
        if (emailAddress == null) {
            return ValidationResult.VALID_NO_ERRORS;
        }
        return NumEmailAddressValidator.validate(emailAddress);
    }

    public static ValidationResult validate(String emailAddress) {
        ValidationResult result = new ValidationResult();
        try {
            if (emailAddress == null) {
                result.addMessage(ValidationResult.ErrorCode.NULL_UNACCEPTABLE, "emailAddress");
            } else {
                String[] parts = emailAddress.split("@");
                if (parts.length < 2) {
                    result.addMessage(ValidationResult.ErrorCode.NO_AT_SYMBOL, emailAddress);
                }
                if (parts.length > 2) {
                    result.addMessage(ValidationResult.ErrorCode.TOO_MANY_AT_SYMBOLS, emailAddress);
                }
                String localPart = parts[0];
                String domain = parts[1];
                result.merge(NumDomainValidator.validate(domain));
                if (localPart.getBytes().length > 64) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_TOO_LONG, localPart);
                }
                if (localPart.getBytes().length == 0) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_IS_EMPTY, localPart);
                }
                if (localPart.contains("..")) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_CONTAINS_DOUBLE_DOT, localPart);
                }
                if (localPart.startsWith(".")) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_CONTAINS_STARTS_WITH_DOT, localPart);
                }
                if (localPart.endsWith(".")) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_CONTAINS_ENDS_WITH_DOT, localPart);
                }
                if (localPart.contains("\n")) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_CONTAINS_NEWLINE, localPart);
                }
                if (localPart.contains("\r")) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_CONTAINS_CARRIAGE_RETURN, localPart);
                }
                if (localPart.contains("\t")) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_CONTAINS_TAB, localPart);
                }
                if (localPart.contains("\b")) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_CONTAINS_BACKSPACE, localPart);
                }
                if (localPart.contains("\f")) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_CONTAINS_FORMFEED, localPart);
                }
                if (localPart.contains("\\")) {
                    result.addMessage(ValidationResult.ErrorCode.LOCAL_PART_OF_EMAIL_CONTAINS_BACKSLASH, localPart);
                }
                if (!NUM_EMAIL_REGEX.matcher(emailAddress).matches()) {
                    result.addMessage(ValidationResult.ErrorCode.PATTERN_MISMATCH, emailAddress);
                }
            }
        }
        catch (Exception e) {
            result.addMessage(ValidationResult.ErrorCode.EXCEPTION_MESSAGE, e.getMessage());
        }
        return result;
    }
}

