/*
 * Decompiled with CFR 0.152.
 */
package uk.num.validators;

import java.util.Arrays;
import java.util.regex.Pattern;
import uk.num.validators.ValidationResult;

public class NumDomainValidator {
    public static final Pattern NUM_DOMAIN_REGEX = Pattern.compile("^(([^.\\s\f\t\r\b]+?\\.)*?([^!\"#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~\\s\f\t\r\b]+?\\.)([^!\"#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~\\s\f\t\r\b]+?))\\.??$");
    public static final int MAX_DOMAIN_NAME_LENGTH = 253;
    public static final int MAX_LABEL_LENGTH = 63;

    private NumDomainValidator() {
    }

    public static ValidationResult validateAcceptingNullAsValid(String domain) {
        if (domain == null) {
            return ValidationResult.VALID_NO_ERRORS;
        }
        return NumDomainValidator.validate(domain);
    }

    public static ValidationResult validate(String domain) {
        ValidationResult result = new ValidationResult();
        try {
            if (domain == null) {
                result.addMessage(ValidationResult.ErrorCode.NULL_UNACCEPTABLE, "domain");
            } else {
                if (domain.getBytes().length > 253) {
                    result.addMessage(ValidationResult.ErrorCode.DOMAIN_NAME_TOO_LONG, domain);
                }
                if (domain.startsWith("-")) {
                    result.addMessage(ValidationResult.ErrorCode.HYPHEN_AT_START_OF_DOMAIN, domain);
                }
                if (domain.endsWith("-")) {
                    result.addMessage(ValidationResult.ErrorCode.HYPHEN_AT_END_OF_DOMAIN, domain);
                }
                Arrays.stream(domain.split("\\.")).forEach(label -> {
                    if (label.getBytes().length == 0) {
                        result.addMessage(ValidationResult.ErrorCode.ZERO_LENGTH_LABEL, domain);
                    } else if (label.getBytes().length > 63) {
                        result.addMessage(ValidationResult.ErrorCode.LABEL_TOO_LONG, (String)label);
                    }
                    if (label.contains(" ")) {
                        result.addMessage(ValidationResult.ErrorCode.SPACES_IN_LABEL, (String)label);
                    }
                    if (label.contains("\f")) {
                        result.addMessage(ValidationResult.ErrorCode.FORM_FEED_IN_LABEL, (String)label);
                    }
                    if (label.contains("\t")) {
                        result.addMessage(ValidationResult.ErrorCode.TAB_IN_LABEL, (String)label);
                    }
                    if (label.contains("\r")) {
                        result.addMessage(ValidationResult.ErrorCode.CARRIAGE_RETURN_IN_LABEL, (String)label);
                    }
                    if (label.contains("\b")) {
                        result.addMessage(ValidationResult.ErrorCode.BACKSPACE_IN_LABEL, (String)label);
                    }
                    if (label.contains("\n")) {
                        result.addMessage(ValidationResult.ErrorCode.NEWLINE_IN_LABEL, (String)label);
                    }
                });
                if (!NUM_DOMAIN_REGEX.matcher(domain).matches()) {
                    result.addMessage(ValidationResult.ErrorCode.PATTERN_MISMATCH, domain);
                }
            }
        }
        catch (Exception e) {
            result.addMessage(ValidationResult.ErrorCode.EXCEPTION_MESSAGE, e.getMessage());
        }
        return result;
    }
}

