/*
 * Decompiled with CFR 0.152.
 */
package uk.num.json_modl.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import uk.num.json_modl.converter.NamedNode;
import uk.num.json_modl.converter.UnicodeEscaper;

class UtilFuncs {
    static final UnaryOperator<String> escapeGraves = s -> s != null ? StringUtils.replace((String)s, (String)"`", (String)"~`") : s;
    private static final Pattern shouldBeGraveQuoted = Pattern.compile(".*[()\\[\\];{}=].*");
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final UnaryOperator<String> graveQuoteIfNecessary = s -> s != null && (shouldBeGraveQuoted.matcher((CharSequence)s).matches() || StringUtils.isEmpty((CharSequence)s) || StringUtils.isNumeric((CharSequence)s) || "true".equals(s) || "false".equals(s) || "null".equals(s)) ? "`" + s + "`" : s;
    private static final UnaryOperator<String> doubleQuoteIfNecessary = s -> s != null && s.contains("~`") ? "\"" + s + "\"" : s;
    private static final UnaryOperator<String> replaceNbsp = s -> s != null && s.contains("\u00a0") ? s.replace("\u00a0", " ") : s;
    static final Function<String, String> escapeAndQuote = doubleQuoteIfNecessary.compose(graveQuoteIfNecessary).compose(escapeGraves).compose(UnicodeEscaper.escape).compose(replaceNbsp);
    static Function<String, JsonNode> mapJson = s -> {
        try {
            return mapper.readTree(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
    static Function<ArrayNode, List<JsonNode>> toList = node -> {
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        for (int i = 0; i < node.size(); ++i) {
            nodes.add(node.get(i));
        }
        return nodes;
    };
    static Function<JsonNode, List<NamedNode>> toNamedNodeList = node -> {
        Iterator elements = node.fieldNames();
        ArrayList<NamedNode> nodes = new ArrayList<NamedNode>();
        while (elements.hasNext()) {
            String field = (String)elements.next();
            nodes.add(new NamedNode(field, node.get(field)));
        }
        return nodes;
    };
    private static List<String> primitives = Arrays.asList("true", "false", "null");

    private UtilFuncs() {
    }

    public static boolean isNonStringPrimitive(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return primitives.contains(s) || StringUtils.isNumeric((CharSequence)s);
    }
}

