/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.vavr.control.Either;
import java.util.List;
import lombok.NonNull;
import uk.modl.interpreter.model.Modl;
import uk.modl.interpreter.model.ModlArray;
import uk.modl.interpreter.model.ModlBoolNull;
import uk.modl.interpreter.model.ModlFloat;
import uk.modl.interpreter.model.ModlInteger;
import uk.modl.interpreter.model.ModlMap;
import uk.modl.interpreter.model.ModlPair;
import uk.modl.interpreter.model.ModlPrimitive;
import uk.modl.interpreter.model.ModlQuoted;
import uk.modl.interpreter.model.ModlString;
import uk.modl.interpreter.model.ModlStructure;
import uk.modl.interpreter.model.ModlValue;
import uk.modl.utils.StringEscapeReplacer;

public final class ModlToJson {
    public static JsonNode convert(@NonNull Modl modl) {
        if (modl == null) {
            throw new NullPointerException("modl is marked non-null but is null");
        }
        @NonNull Either<ModlPrimitive, List<ModlStructure>> structures = modl.getStructures();
        Either jsonNodes = structures.bimap(ModlToJson::toJson, list -> {
            if (list.size() == 1 && list.get(0) instanceof ModlArray) {
                return ModlToJson.arrayToJson((ModlArray)list.get(0));
            }
            @NonNull ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
            list.forEach(structure -> {
                if (structure instanceof ModlPair) {
                    ModlToJson.pairToJson((ModlPair)structure, result);
                }
                if (structure instanceof ModlMap) {
                    ModlToJson.mapToJson((ModlMap)structure, result);
                }
                if (structure instanceof ModlArray) {
                    throw new RuntimeException("Array cannot be stored directly in a map, it must be a pair");
                }
            });
            return result.size() == 0 ? null : result;
        });
        if (jsonNodes.isLeft()) {
            return (JsonNode)jsonNodes.getLeft();
        }
        return (JsonNode)jsonNodes.get();
    }

    private static JsonNode toJson(@NonNull ModlValue value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (value instanceof ModlArray) {
            return ModlToJson.arrayToJson((ModlArray)value);
        }
        if (value instanceof ModlMap) {
            return ModlToJson.mapToJson((ModlMap)value, new ObjectNode(JsonNodeFactory.instance));
        }
        if (value instanceof ModlPair) {
            return ModlToJson.pairToJson((ModlPair)value, new ObjectNode(JsonNodeFactory.instance));
        }
        if (value instanceof ModlQuoted) {
            return new TextNode(StringEscapeReplacer.replace(ModlToJson.unquote(((ModlQuoted)value).getValue())));
        }
        if (value instanceof ModlInteger) {
            return new IntNode(((ModlInteger)value).getValue());
        }
        if (value instanceof ModlFloat) {
            return new FloatNode(((ModlFloat)value).getValue());
        }
        if (value instanceof ModlString) {
            return new TextNode(StringEscapeReplacer.replace(ModlToJson.unquote(((ModlString)value).getValue())));
        }
        if (value == ModlBoolNull.MODL_FALSE) {
            return BooleanNode.FALSE;
        }
        if (value == ModlBoolNull.MODL_TRUE) {
            return BooleanNode.TRUE;
        }
        if (value == ModlBoolNull.MODL_NULL) {
            return null;
        }
        return NullNode.instance;
    }

    private static String unquote(String s) {
        return s.startsWith("`") && s.endsWith("`") || s.startsWith("\"") && s.endsWith("\"") ? s.substring(1, s.length() - 1) : s;
    }

    private static JsonNode pairToJson(ModlPair p, ObjectNode result) {
        String key = StringEscapeReplacer.replace(ModlToJson.unquote(p.getKey()));
        result.set(key, ModlToJson.toJson((ModlValue)((Object)p.getValue())));
        return result;
    }

    private static JsonNode mapToJson(ModlMap m, ObjectNode result) {
        m.getItems().forEach(i -> ModlToJson.pairToJson(i, result));
        return result;
    }

    private static JsonNode arrayToJson(ModlArray a) {
        ArrayNode result = new ArrayNode(JsonNodeFactory.instance);
        a.getItems().forEach(x -> result.add(ModlToJson.toJson(x)));
        return result;
    }

    private ModlToJson() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

