/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.transforms;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import lombok.NonNull;
import uk.modl.model.Map;
import uk.modl.model.MapItem;
import uk.modl.model.Pair;
import uk.modl.model.Structure;
import uk.modl.transforms.TransformationContext;

public class StarMethodTransform {
    public static boolean isMethodInstruction(String key) {
        String lowerCase = key.toLowerCase();
        return lowerCase.equals("*m") || lowerCase.equals("*method");
    }

    public Tuple2<TransformationContext, Structure> apply(TransformationContext ctx, Structure p) {
        if (p instanceof Pair && StarMethodTransform.isMethodInstruction(((Pair)p).getKey())) {
            TransformationContext updatedContext = this.accept(ctx, (Pair)p);
            return Tuple.of((Object)updatedContext, null);
        }
        return Tuple.of((Object)ctx, (Object)p);
    }

    private TransformationContext accept(TransformationContext ctx, Pair pair) {
        if (pair.getValue() instanceof Map) {
            String name = null;
            String id = null;
            String transform = null;
            for (MapItem mi : ((Map)pair.getValue()).getMapItems()) {
                if (mi instanceof Pair) {
                    Pair p = (Pair)mi;
                    switch (p.getKey().toLowerCase()) {
                        case "*i": 
                        case "*id": {
                            id = p.getValue().toString();
                            break;
                        }
                        case "*n": 
                        case "*name": {
                            name = p.getValue().toString();
                            break;
                        }
                        case "*t": 
                        case "*transform": {
                            transform = p.getValue().toString();
                        }
                    }
                    continue;
                }
                throw new RuntimeException("Expected a Pair but found a " + mi.getClass());
            }
            MethodInstruction m = MethodInstruction.of(id, name, transform);
            return ctx.addMethodInstruction(m);
        }
        throw new RuntimeException("Expected a map for " + pair.getKey() + " but found a " + pair.getValue().getClass());
    }

    public static final class MethodInstruction {
        @NonNull
        private final String id;
        private final String name;
        @NonNull
        private final String transform;

        private MethodInstruction(@NonNull String id, String name, @NonNull String transform) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            if (transform == null) {
                throw new NullPointerException("transform is marked non-null but is null");
            }
            this.id = id;
            this.name = name;
            this.transform = transform;
        }

        public static MethodInstruction of(@NonNull String id, String name, @NonNull String transform) {
            return new MethodInstruction(id, name, transform);
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NonNull
        public String getTransform() {
            return this.transform;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodInstruction)) {
                return false;
            }
            MethodInstruction other = (MethodInstruction)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$transform = this.getTransform();
            String other$transform = other.getTransform();
            return !(this$transform == null ? other$transform != null : !this$transform.equals(other$transform));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $transform = this.getTransform();
            result = result * 59 + ($transform == null ? 43 : $transform.hashCode());
            return result;
        }

        public String toString() {
            return "StarMethodTransform.MethodInstruction(id=" + this.getId() + ", name=" + this.getName() + ", transform=" + this.getTransform() + ")";
        }
    }
}

